/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.refresh;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sphinx.emf.explorer.IModelCommonContentProvider;
import org.eclipse.sphinx.emf.explorer.refresh.AbstractRefreshStrategy;

public class ModelResourceRefreshStrategy
extends AbstractRefreshStrategy
implements Runnable {
    private static final int MAX_INDIVIDUAL_MODEL_RESOURCE_REFRESHES = 20;
    private Set<Resource> modelResourcesToRefresh = null;

    public ModelResourceRefreshStrategy(IModelCommonContentProvider contentProvider, boolean affectsTreeViewerState) {
        super(contentProvider, affectsTreeViewerState);
    }

    public Set<Resource> getModelResourcesToRefresh() {
        if (this.modelResourcesToRefresh == null) {
            this.modelResourcesToRefresh = new HashSet<Resource>();
        }
        return this.modelResourcesToRefresh;
    }

    @Override
    protected boolean shouldPerformSelectiveRefresh() {
        return this.getModelResourcesToRefresh().size() < 20;
    }

    @Override
    protected void performSelectiveRefresh(StructuredViewer viewer) {
        for (Resource modelResource : this.getModelResourcesToRefresh()) {
            IResource workspaceResource = this.contentProvider.getWorkspaceResource(modelResource);
            if (workspaceResource == null || !workspaceResource.isAccessible() || !this.contentProvider.isTriggerPoint(workspaceResource) && modelResource.isLoaded()) continue;
            viewer.refresh((Object)workspaceResource, true);
        }
    }
}

