/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.scoping;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.scoping.AbstractResourceScope;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;

public class FileResourceScope
extends AbstractResourceScope {
    protected IFile rootFile;

    public FileResourceScope(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.rootFile = EcorePlatformUtil.getFile(resource);
    }

    @Override
    public IResource getRoot() {
        return this.rootFile;
    }

    @Override
    public Collection<IResource> getReferencedRoots() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IResource> getReferencingRoots() {
        return Collections.emptySet();
    }

    @Override
    public boolean belongsTo(IFile file, boolean includeReferencedScopes) {
        if (this.belongsToRootFile(file, includeReferencedScopes)) {
            return true;
        }
        return this.isShared(file);
    }

    @Override
    public boolean belongsTo(Resource resource, boolean includeReferencedScopes) {
        IFile file = EcorePlatformUtil.getFile(resource);
        if (this.belongsToRootFile(file, includeReferencedScopes)) {
            return true;
        }
        return this.isShared(resource);
    }

    @Override
    public boolean belongsTo(URI uri, boolean includeReferencedScopes) {
        IFile file = EcorePlatformUtil.getFile(uri);
        if (this.belongsToRootFile(file, includeReferencedScopes)) {
            return true;
        }
        return this.isShared(uri);
    }

    @Override
    public boolean didBelongTo(IFile file, boolean includeReferencedScopes) {
        return this.belongsToRootFile(file, includeReferencedScopes);
    }

    @Override
    public boolean didBelongTo(Resource resource, boolean includeReferencedScopes) {
        IFile file = EcorePlatformUtil.getFile(resource);
        return this.belongsToRootFile(file, includeReferencedScopes);
    }

    @Override
    public boolean didBelongTo(URI uri, boolean includeReferencedScopes) {
        IFile file = EcorePlatformUtil.getFile(uri);
        return this.belongsToRootFile(file, includeReferencedScopes);
    }

    protected boolean belongsToRootFile(IFile file, boolean includeReferencedScopes) {
        return this.rootFile.equals((Object)file);
    }
}

