/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms.pages;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.sphinx.emf.editors.forms.BasicTransactionalFormEditor;
import org.eclipse.sphinx.emf.editors.forms.internal.Activator;
import org.eclipse.sphinx.emf.editors.forms.sections.IFormSection;
import org.eclipse.sphinx.emf.ui.forms.messages.IFormMessage;
import org.eclipse.sphinx.emf.ui.forms.messages.IFormMessageProvider;
import org.eclipse.sphinx.emf.validation.IValidationProblemMarkersChangeListener;
import org.eclipse.sphinx.emf.validation.ValidationProblemMarkersChangeNotifier;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public abstract class AbstractFormPage
extends FormPage {
    private static final String EXTP_FORM_MESSAGE_PROVIDERS = "org.eclipse.sphinx.emf.editors.forms.formMessageProvider";
    private static final String NODE_PROVIDER = "formMessageProvider";
    private static final String ATTR_CLASS = "class";
    protected Object pageInput = null;
    private boolean creating = false;
    private boolean created = false;
    private List<IFormSection> sections = new ArrayList<IFormSection>();
    private IFormSection activeSection;
    private IContentProvider contentProvider;
    private IBaseLabelProvider labelProvider;
    private List<IFormMessageProvider> messageProviders = new ArrayList<IFormMessageProvider>();
    protected IPropertyListener inputChangeListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (source.equals(AbstractFormPage.this.getEditor()) && ((Object)((Object)AbstractFormPage.this)).equals(((FormEditor)source).getActivePageInstance()) && propId == 258) {
                AbstractFormPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!AbstractFormPage.this.created) {
                            AbstractFormPage.this.createFormContent(AbstractFormPage.this.getManagedForm());
                        } else {
                            AbstractFormPage.this.setPageInput(AbstractFormPage.this.getPageInputFromEditor());
                        }
                    }
                });
            }
        }
    };
    protected IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            if (event.getSelectedPage().equals((Object)AbstractFormPage.this)) {
                AbstractFormPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFormPage.this.refreshPage();
                    }
                });
            }
        }
    };
    protected IOperationHistoryListener operationHistoryListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            switch (event.getEventType()) {
                case 4: 
                case 9: 
                case 10: {
                    if (!((Object)((Object)AbstractFormPage.this)).equals(AbstractFormPage.this.getEditor().getActivePageInstance())) break;
                    AbstractFormPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractFormPage.this.refreshPage();
                        }
                    });
                }
            }
        }
    };
    protected IValidationProblemMarkersChangeListener validationProblemMarkersChangeListener = new IValidationProblemMarkersChangeListener(){

        public void validationProblemMarkersChanged(EventObject event) {
            if (((Object)((Object)AbstractFormPage.this)).equals(AbstractFormPage.this.getEditor().getActivePageInstance()) && (EObject)event.getSource() == AbstractFormPage.this.pageInput) {
                AbstractFormPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFormPage.this.refreshMessages();
                    }
                });
            }
        }
    };

    public AbstractFormPage(FormEditor editor, String title) {
        this(editor, title.replaceAll("[^A-Z]", ""), title);
    }

    public AbstractFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.getEditor().addPropertyListener(this.inputChangeListener);
        this.getEditor().addPageChangedListener(this.pageChangedListener);
        IOperationHistory operationHistory = this.getTransactionalFormEditor().getOperationHistory();
        if (operationHistory != null) {
            operationHistory.addOperationHistoryListener(this.operationHistoryListener);
        }
        ValidationProblemMarkersChangeNotifier.INSTANCE.addListener(this.validationProblemMarkersChangeListener);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(EXTP_FORM_MESSAGE_PROVIDERS);
        this.messageProviders = new ArrayList<IFormMessageProvider>();
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfgElem = iConfigurationElementArray[n2];
            if (NODE_PROVIDER.equals(cfgElem.getName())) {
                try {
                    IFormMessageProvider msgProvider = (IFormMessageProvider)cfgElem.createExecutableExtension(ATTR_CLASS);
                    this.messageProviders.add(msgProvider);
                }
                catch (CoreException ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                }
            }
            ++n2;
        }
    }

    public BasicTransactionalFormEditor getTransactionalFormEditor() {
        return (BasicTransactionalFormEditor)this.getEditor();
    }

    public AdapterFactoryItemDelegator getItemDelegator() {
        return this.getTransactionalFormEditor().getItemDelegator();
    }

    public IContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    protected IContentProvider createContentProvider() {
        EditingDomain editingDomain;
        AdapterFactory adapterFactory = this.getTransactionalFormEditor().getAdapterFactory();
        if (adapterFactory != null && (editingDomain = this.getTransactionalFormEditor().getEditingDomain()) instanceof TransactionalEditingDomain) {
            return new TransactionalAdapterFactoryContentProvider((TransactionalEditingDomain)editingDomain, adapterFactory);
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = this.createLabelProvider();
        }
        return this.labelProvider;
    }

    protected IBaseLabelProvider createLabelProvider() {
        EditingDomain editingDomain;
        AdapterFactory adapterFactory = this.getTransactionalFormEditor().getAdapterFactory();
        if (adapterFactory != null && (editingDomain = this.getTransactionalFormEditor().getEditingDomain()) instanceof TransactionalEditingDomain) {
            return new TransactionalAdapterFactoryLabelProvider((TransactionalEditingDomain)editingDomain, adapterFactory);
        }
        return null;
    }

    public List<IFormSection> getSections() {
        return this.sections;
    }

    @Deprecated
    public List<IFormSection> getFormSections() {
        return this.getSections();
    }

    protected void addSection(IFormSection section) {
        if (section != null) {
            this.sections.add(section);
        }
    }

    public void setActiveSection(IFormSection section) {
        this.activeSection = section;
    }

    public IFormSection getActiveSection() {
        return this.activeSection;
    }

    protected Object getPageInputFromEditor() {
        return this.getTransactionalFormEditor().getEditorInputObject();
    }

    protected void setPageInput(Object pageInput) {
        this.pageInput = pageInput;
        for (IFormSection section : this.sections) {
            section.setSectionInput(pageInput);
        }
    }

    protected boolean canCreateFormContent() {
        return this.pageInput != null;
    }

    protected final synchronized void createFormContent(IManagedForm managedForm) {
        if (!this.created && !this.creating) {
            this.creating = true;
            this.setPageInput(this.getPageInputFromEditor());
            if (managedForm != null && this.canCreateFormContent()) {
                managedForm.getForm().setText(this.getTitle());
                this.doCreateFormContent(managedForm);
                managedForm.getForm().getBody().layout(true);
                this.created = true;
                this.refreshMessages();
            }
            this.creating = false;
        }
    }

    protected abstract void doCreateFormContent(IManagedForm var1);

    public void dispose() {
        this.sections.clear();
        ValidationProblemMarkersChangeNotifier.INSTANCE.removeListener(this.validationProblemMarkersChangeListener);
        IOperationHistory operationHistory = this.getTransactionalFormEditor().getOperationHistory();
        if (operationHistory != null) {
            operationHistory.removeOperationHistoryListener(this.operationHistoryListener);
        }
        this.getEditor().removePageChangedListener(this.pageChangedListener);
        this.getEditor().removePropertyListener(this.inputChangeListener);
        super.dispose();
    }

    protected final void refreshPage() {
        if (!this.created) {
            this.createFormContent(this.getManagedForm());
        } else {
            this.doRefreshPage();
        }
    }

    protected void doRefreshPage() {
        Command command;
        IUndoableOperation operation;
        IOperationHistory operationHistory;
        for (IFormSection section : this.sections) {
            section.refreshSection();
        }
        IUndoContext undoContext = (IUndoContext)this.getTransactionalFormEditor().getAdapter(IUndoContext.class);
        if (undoContext != null && (operationHistory = this.getTransactionalFormEditor().getOperationHistory()) != null && (operation = operationHistory.getUndoOperation(undoContext)) instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null) {
            this.getTransactionalFormEditor().setSelectionToViewer(command.getAffectedObjects());
        }
    }

    protected final void refreshMessages() {
        this.getManagedForm().getMessageManager().removeAllMessages();
        for (IFormMessageProvider provider : this.messageProviders) {
            Map messages = provider.getMessages(this.pageInput);
            if (messages.size() <= 0) continue;
            this.doRefreshMessages(this.getManagedForm().getMessageManager(), messages);
        }
    }

    protected void doRefreshMessages(IMessageManager messageManager, Map<EStructuralFeature, Set<IFormMessage>> messages) {
        for (IFormSection section : this.sections) {
            section.refreshMessages(messageManager, messages);
        }
    }

    public boolean isEmpty() {
        return !this.created;
    }
}

