/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.geography.centers.GeographicCenters;
import org.eclipse.stem.populationmodels.Activator;
import org.eclipse.stem.populationmodels.standard.SeasonalPopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelValueImpl;

public class SeasonalPopulationModelImpl
extends StandardPopulationModelImpl
implements SeasonalPopulationModel {
    private static final double MILLIS_PER_DAY = 8.64E7;
    protected double seasonalModulationExponent = 2.0;
    private static final double EQUATOR_LATITUDE = 0.0;
    private static final boolean TROPICAL_ONLY = true;
    public static final double TROPIC_OF_CANCER_LATITUDE = 23.439444;
    private static final double LATITUDE_SIGMOID_WIDTH = 4.5;
    protected static final double PHASE_EDEFAULT = 0.0;
    protected double phase = 0.0;
    protected static final double MODULATION_AMPLITUDE_EDEFAULT = 1.0;
    protected double modulationAmplitude = 1.0;
    protected static final double PERIOD_EDEFAULT = 365.25;
    protected double period = 365.25;
    protected static final boolean USE_LATITUDE_EDEFAULT = true;
    protected boolean useLatitude = true;

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedBirthRate = this.adjustRate(this.getBirthRate(), this.getTimePeriod(), timeDelta);
        double adjustedDeathRate = this.adjustRate(this.getDeathRate(), this.getTimePeriod(), timeDelta);
        double localPhase = this.getPhase();
        for (DynamicLabel label : labels) {
            StandardPopulationModelLabelImpl slabel = (StandardPopulationModelLabelImpl)label;
            if (this.checkAndAdjustForNegative(slabel)) continue;
            StandardPopulationModelLabelValueImpl delta = (StandardPopulationModelLabelValueImpl)slabel.getDeltaValue();
            StandardPopulationModelLabelValue current = (StandardPopulationModelLabelValue)slabel.getProbeValue();
            double seasonalBirthFactor = 0.0;
            double currentPopulation = current.getCount();
            double latitude = 0.0;
            double currentMillis = time.getTime().getTime();
            double latFactor = 1.0;
            localPhase = this.getPhase();
            if (this.isUseLatitude()) {
                double[] lat_long = null;
                Node node = slabel.getNode();
                if (node instanceof RegionImpl) {
                    String nodeURI = node.getURI().lastSegment();
                    lat_long = GeographicCenters.getCenter((String)nodeURI);
                    if (lat_long == null) {
                        LatLongProviderAdapter latLongProviderB = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)node, LatLongProvider.class);
                        lat_long = latLongProviderB.getCenter();
                    }
                    if (lat_long == null) {
                        Activator.logError("Cannot find latitude for " + nodeURI, null);
                    }
                } else {
                    lat_long = new double[]{0.0, 0.0};
                }
                if (lat_long != null) {
                    latitude = lat_long[0];
                }
                latFactor = 1.0 / (1.0 + Math.exp((23.439444 - Math.abs(latitude)) / 4.5));
                if (latitude <= 0.0) {
                    localPhase = this.getPhase() + Math.PI;
                }
            }
            double modulation = this.getModulationAmplitude() * latFactor;
            double floor = 1.0 - modulation;
            double modulationPeriod = this.getPeriod();
            double oscCos = Math.cos(localPhase + Math.PI * 2 * currentMillis / (modulationPeriod * 8.64E7));
            seasonalBirthFactor = (1.0 + -1.0 * oscCos) / 2.0;
            double oscBirthRate = adjustedBirthRate * Math.abs(seasonalBirthFactor *= modulation);
            oscBirthRate += floor * adjustedBirthRate;
            double births = currentPopulation * (oscBirthRate *= this.getTropicalEnvelope(latitude, 46.878888));
            double deaths = currentPopulation * adjustedDeathRate;
            currentPopulation += births;
            currentPopulation -= deaths;
            delta.setCount(births - deaths);
            delta.setBirths(births);
            delta.setDeaths(deaths);
            this.computeAdditionalDeltasAndExchanges(slabel, time, deaths, timeDelta);
        }
    }

    private double getTropicalEnvelope(double lat, double sigma) {
        double exp = -(lat * lat / (2.0 * sigma * sigma));
        return Math.exp(exp);
    }

    private double getGausianUnnormalize(double x, double mu, double sigma) {
        double exp = -((x - mu) * (x - mu) / (2.0 * sigma * sigma));
        return Math.exp(exp);
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SEASONAL_POPULATION_MODEL;
    }

    @Override
    public double getPhase() {
        return this.phase;
    }

    @Override
    public void setPhase(double newPhase) {
        this.phase = newPhase;
    }

    @Override
    public double getModulationAmplitude() {
        return this.modulationAmplitude;
    }

    @Override
    public void setModulationAmplitude(double newModulationAmplitude) {
        this.modulationAmplitude = newModulationAmplitude;
    }

    @Override
    public double getPeriod() {
        return this.period;
    }

    @Override
    public boolean isUseLatitude() {
        return this.useLatitude;
    }

    @Override
    public void setUseLatitude(boolean newUseLatitude) {
        this.useLatitude = newUseLatitude;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.getPhase();
            }
            case 19: {
                return this.getModulationAmplitude();
            }
            case 20: {
                return this.getPeriod();
            }
            case 21: {
                return this.isUseLatitude();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.setPhase((Double)newValue);
                return;
            }
            case 19: {
                this.setModulationAmplitude((Double)newValue);
                return;
            }
            case 21: {
                this.setUseLatitude((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.setPhase(0.0);
                return;
            }
            case 19: {
                this.setModulationAmplitude(1.0);
                return;
            }
            case 21: {
                this.setUseLatitude(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return this.phase != 0.0;
            }
            case 19: {
                return this.modulationAmplitude != 1.0;
            }
            case 20: {
                return this.period != 365.25;
            }
            case 21: {
                return !this.useLatitude;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (phase: ");
        result.append(this.phase);
        result.append(", modulationAmplitude: ");
        result.append(this.modulationAmplitude);
        result.append(", period: ");
        result.append(this.period);
        result.append(", useLatitude: ");
        result.append(this.useLatitude);
        result.append(')');
        return result.toString();
    }
}

