/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.common.presentation;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stem.core.common.presentation.CoreEditorPlugin;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.handlers.SwitchLocaleAction;
import org.eclipse.stem.ui.launcher.LauncherFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public final class CoreEditorAdvisor
extends WorkbenchAdvisor {
    private static String getString(String key) {
        return CoreEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return CoreEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        this.declareWorkbenchImages();
    }

    public IAdaptable getDefaultPageInput() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root;
    }

    public void preStartup() {
        IDE.registerAdapters();
    }

    public void postStartup() {
    }

    private void declareWorkbenchImages() {
        String ICONS_PATH = "$nl$/icons/full/";
        String PATH_ELOCALTOOL = "$nl$/icons/full/elcl16/";
        String PATH_DLOCALTOOL = "$nl$/icons/full/dlcl16/";
        String PATH_ETOOL = "$nl$/icons/full/etool16/";
        String PATH_DTOOL = "$nl$/icons/full/dtool16/";
        String PATH_OBJECT = "$nl$/icons/full/obj16/";
        String PATH_WIZBAN = "$nl$/icons/full/wizban/";
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "$nl$/icons/full/dtool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "$nl$/icons/full/dtool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_NEXT_NAV", "$nl$/icons/full/etool16/next_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PREVIOUS_NAV", "$nl$/icons/full/etool16/prev_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWPRJ_WIZ", "$nl$/icons/full/wizban/newprj_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "$nl$/icons/full/wizban/newfolder_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFILE_WIZ", "$nl$/icons/full/wizban/newfile_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "$nl$/icons/full/wizban/importdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "$nl$/icons/full/wizban/importzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "$nl$/icons/full/wizban/exportdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/exportzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/workset_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "$nl$/icons/full/wizban/saveas_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_QUICKFIX_DLG", "$nl$/icons/full/wizban/quick_fix.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.png", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OPEN_MARKER", "$nl$/icons/full/elcl16/gotoobj_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ELCL_QUICK_FIX_ENABLED", "$nl$/icons/full/elcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_DLCL_QUICK_FIX_DISABLED", "$nl$/icons/full/dlcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_TASK_TSK", "$nl$/icons/full/obj16/taskmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_BKMRK_TSK", "$nl$/icons/full/obj16/bkmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_COMPLETE_TSK", "$nl$/icons/full/obj16/complete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INCOMPLETE_TSK", "$nl$/icons/full/obj16/incomplete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_ITEM", "$nl$/icons/full/obj16/welcome_item.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_BANNER", "$nl$/icons/full/obj16/welcome_banner.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_FLAT_LAYOUT", "$nl$/icons/full/elcl16/flatLayout.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_HIERARCHICAL_LAYOUT", "$nl$/icons/full/elcl16/hierarchicalLayout.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.gif", true);
    }

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)ideBundle, (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public static String openFilePathDialog(Shell shell, String fileExtensionFilter, int style) {
        FileDialog fileDialog = new FileDialog(shell, style);
        if (fileExtensionFilter == null) {
            fileExtensionFilter = "*." + CoreEditorAdvisor.getString("_UI_CommonEditorFilenameExtension") + ";" + "*." + CoreEditorAdvisor.getString("_UI_GraphEditorFilenameExtension") + ";" + "*." + CoreEditorAdvisor.getString("_UI_ModelEditorFilenameExtension") + ";" + "*." + CoreEditorAdvisor.getString("_UI_ScenarioEditorFilenameExtension") + ";" + "*." + CoreEditorAdvisor.getString("_UI_SequencerEditorFilenameExtension");
        }
        fileDialog.setFilterExtensions(new String[]{fileExtensionFilter});
        fileDialog.open();
        if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
            return String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
        }
        return null;
    }

    public static boolean openEditor(IWorkbench workbench, URI fileURI) {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            Path path = new Path(fileURI.toPlatformString(true));
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            IDE.openEditor((IWorkbenchPage)page, (IFile)f, (boolean)true);
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)CoreEditorAdvisor.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public String getInitialWindowPerspectiveId() {
        return "org.eclipse.stem.ui.STEMSimulationPerspective";
    }

    public String getMainPreferencePageId() {
        return "org.eclipse.stem.ui.preferences.STEMPreferencePage";
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new WindowAdvisor(configurer);
    }

    public static class AboutAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            MessageDialog.openInformation((Shell)this.getWindow().getShell(), (String)CoreEditorAdvisor.getString("_UI_About_title"), (String)CoreEditorAdvisor.getString("_UI_About_text"));
        }
    }

    public static class Application
    implements IApplication {
        public Object start(IApplicationContext context) throws Exception {
            return LauncherFactory.getLauncher(context).launch();
        }

        public void stop() {
        }
    }

    public static class OpenAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            String filePath = CoreEditorAdvisor.openFilePathDialog(this.getWindow().getShell(), null, 4096);
            if (filePath != null) {
                CoreEditorAdvisor.openEditor(this.getWindow().getWorkbench(), URI.createFileURI((String)filePath));
            }
        }
    }

    public static class OpenURIAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            LoadResourceAction.LoadResourceDialog loadResourceDialog = new LoadResourceAction.LoadResourceDialog(this.getWindow().getShell());
            if (loadResourceDialog.open() == 0) {
                for (URI uri : loadResourceDialog.getURIs()) {
                    CoreEditorAdvisor.openEditor(this.getWindow().getWorkbench(), uri);
                }
            }
        }
    }

    public static class Perspective
    implements IPerspectiveFactory {
        public static final String ID_PERSPECTIVE = "org.eclipse.stem.core.common.presentation.CoreEditorAdvisorPerspective";

        public void createInitialLayout(IPageLayout layout) {
            layout.setEditorAreaVisible(true);
            layout.addPerspectiveShortcut(ID_PERSPECTIVE);
            IFolderLayout right = layout.createFolder("right", 2, 0.66f, layout.getEditorArea());
            right.addView("org.eclipse.ui.views.ContentOutline");
            IFolderLayout bottonRight = layout.createFolder("bottonRight", 4, 0.6f, "right");
            bottonRight.addView("org.eclipse.ui.views.PropertySheet");
        }
    }

    public static class WindowActionBarAdvisor
    extends ActionBarAdvisor {
        public WindowActionBarAdvisor(IActionBarConfigurer configurer) {
            super(configurer);
        }

        protected void fillMenuBar(IMenuManager menuBar) {
            IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
            menuBar.add((IContributionItem)this.createFileMenu(window));
            menuBar.add((IContributionItem)this.createEditMenu(window));
            menuBar.add((IContributionItem)new GroupMarker("additions"));
            menuBar.add((IContributionItem)this.createWindowMenu(window));
            menuBar.add((IContributionItem)this.createHelpMenu(window));
        }

        protected IMenuManager createFileMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_File_label"), "file");
            menu.add((IContributionItem)new GroupMarker("fileStart"));
            MenuManager newMenu = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_New_label"), "new");
            newMenu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IContributionItem)newMenu);
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CLOSE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CLOSE_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE_AS.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.IMPORT.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.EXPORT.create(window));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)SwitchLocaleAction.SWITCH_LOCALE_ACTION.create(window));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.QUIT.create(window));
            menu.add((IContributionItem)new GroupMarker("fileEnd"));
            return menu;
        }

        protected IMenuManager createEditMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_Edit_label"), "edit");
            menu.add((IContributionItem)new GroupMarker("editStart"));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.UNDO.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.REDO.create(window));
            menu.add((IContributionItem)new GroupMarker("undo.ext"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CUT.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.COPY.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.PASTE.create(window));
            menu.add((IContributionItem)new GroupMarker("cut.ext"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.DELETE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SELECT_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)new GroupMarker("find.ext"));
            menu.add((IContributionItem)new GroupMarker("add.ext"));
            menu.add((IContributionItem)new GroupMarker("editEnd"));
            menu.add((IContributionItem)new Separator("additions"));
            return menu;
        }

        protected IMenuManager createWindowMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_Window_label"), "window");
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.OPEN_PERSPECTIVE_DIALOG.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.OPEN_NEW_WINDOW.create(window));
            menu.add(ContributionItemFactory.OPEN_WINDOWS.create(window));
            menu.add(ContributionItemFactory.VIEWS_SHORTLIST.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.PREFERENCES.create(window));
            menu.add((IContributionItem)new Separator("additions"));
            ActionFactory.IWorkbenchAction resetPerspective = ActionFactory.RESET_PERSPECTIVE.create(window);
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)resetPerspective);
            menu.add((IContributionItem)new GroupMarker("additions"));
            return menu;
        }

        protected IMenuManager createHelpMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_Help_label"), "help");
            ActionFactory.IWorkbenchAction helpIntro = ActionFactory.INTRO.create(window);
            ActionFactory.IWorkbenchAction aboutAction = ActionFactory.ABOUT.create(window);
            ActionFactory.IWorkbenchAction contentsAction = ActionFactory.HELP_CONTENTS.create(window);
            menu.add((IContributionItem)new GroupMarker("helpStart"));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)helpIntro);
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)contentsAction);
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)aboutAction);
            menu.add((IContributionItem)new GroupMarker("helpEnd"));
            menu.add((IContributionItem)new GroupMarker("additions"));
            return menu;
        }

        protected void addToMenuAndRegister(IMenuManager menuManager, IAction action) {
            menuManager.add(action);
            this.getActionBarConfigurer().registerGlobalAction(action);
        }
    }

    public static class WindowAdvisor
    extends WorkbenchWindowAdvisor {
        public WindowAdvisor(IWorkbenchWindowConfigurer configurer) {
            super(configurer);
        }

        public void preWindowOpen() {
            IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
            configurer.setInitialSize(new Point(1024, 768));
            configurer.setShowCoolBar(true);
            configurer.setShowStatusLine(true);
            configurer.setShowFastViewBars(true);
            configurer.setShowProgressIndicator(true);
            configurer.setShowPerspectiveBar(true);
        }

        public boolean preWindowShellClose() {
            try {
                ResourcesPlugin.getWorkspace().save(true, null);
            }
            catch (CoreException e) {
                Activator.logError("Failed to save workspace before quitting", e);
            }
            return true;
        }

        public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
            return new WindowActionBarAdvisor(configurer);
        }
    }
}

