/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.common.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.provider.CoreEditPlugin;
import org.eclipse.stem.core.common.provider.DublinCoreItemProvider;

public class IdentifiableItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public IdentifiableItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addDublinCorePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptorsGen(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addURIPropertyDescriptor(object);
            this.addTypeURIPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addDublinCorePropertyDescriptor(Object object) {
        DublinCore dc = ((Identifiable)object).getDublinCore();
        ComposeableAdapterFactory factory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        DublinCoreItemProvider dcItemProvider = (DublinCoreItemProvider)factory.adapt((Notifier)dc, IItemPropertySource.class);
        List<IItemPropertyDescriptor> dcDescriptors = dcItemProvider.getPropertyDescriptors(dc);
        for (ItemPropertyDescriptor itemPropertyDescriptor : dcDescriptors) {
            this.itemPropertyDescriptors.add(new ItemPropertyDescriptorDecorator(dc, (IItemPropertyDescriptor)itemPropertyDescriptor){

                public String getCategory(Object thisObject) {
                    return IdentifiableItemProvider.this.getString("_UI_Identifiable_dublinCore_feature");
                }

                public String[] getFilterFlags(Object thisObject) {
                    return new String[]{"org.eclipse.ui.views.properties.expert"};
                }
            });
        }
    }

    protected void addURIPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Identifiable_uRI_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Identifiable_uRI_feature", "_UI_Identifiable_type"), (EStructuralFeature)CommonPackage.Literals.IDENTIFIABLE__URI, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addTypeURIPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Identifiable_typeURI_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Identifiable_typeURI_feature", "_UI_Identifiable_type"), (EStructuralFeature)CommonPackage.Literals.IDENTIFIABLE__TYPE_URI, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Identifiable"));
    }

    public String getText(Object object) {
        Identifiable identifiable = (Identifiable)object;
        String title = identifiable.getDublinCore().getTitle();
        if (title != null && !title.equals("")) {
            return String.valueOf(identifiable.getURI().lastSegment()) + " " + title;
        }
        if (identifiable.getURI() != null) {
            return identifiable.getURI().lastSegment();
        }
        return identifiable.toString();
    }

    public String getTextGen(Object object) {
        URI labelValue = ((Identifiable)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_Identifiable_type") : String.valueOf(this.getString("_UI_Identifiable_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Identifiable.class)) {
            case 0: 
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return CoreEditPlugin.INSTANCE;
    }
}

