/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.trigger.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.DecoratorImpl;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.predicate.Predicate;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.core.trigger.TriggerPackage;

public class TriggerImpl
extends DecoratorImpl
implements Trigger {
    protected Predicate predicate;
    protected EList<Decorator> actions;
    protected List<Decorator> actionCopies;

    protected TriggerImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TriggerPackage.Literals.TRIGGER;
    }

    @Override
    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.getActions() != null) {
            if (this.actionCopies == null || this.actionCopies.size() < this.getActions().size()) {
                this.actionCopies = new ArrayList<Decorator>();
                int i = 0;
                while (i < this.getActions().size()) {
                    this.actionCopies.add((Decorator)EcoreUtil.copy((EObject)((Decorator)this.getActions().get(i))));
                    this.getGraph().getDecorators().add((Object)this.actionCopies.get(i));
                    ++i;
                }
            }
            for (Decorator d : this.actionCopies) {
                d.setEnabled(false);
            }
        } else {
            CorePlugin.logInformation("No actions specified for trigger \"" + this.getDublinCore().getTitle() + "\"", null);
        }
        this.getPredicate().reset();
    }

    @Override
    public void updateLabels(STEMTime time, long timerPeriod, int cycle) {
        block7: {
            block6: {
                if (!this.getPredicate().evaluate(time, timerPeriod, (Graph)this.eContainer())) break block6;
                if (this.actionCopies == null) break block7;
                for (Decorator actionCopy : this.actionCopies) {
                    actionCopy.setEnabled(true);
                    if (!actionCopy.isGraphDecorated()) {
                        try {
                            actionCopy.decorateGraph(time);
                        }
                        catch (ScenarioInitializationException sie) {
                            Scenario s = (Scenario)this.eContainer();
                            Utility.handleException(sie.getErrorMessage(), true, sie);
                        }
                        actionCopy.setGraphDecorated(true);
                    }
                    actionCopy.updateLabels(time, timerPeriod, cycle);
                }
                break block7;
            }
            try {
                this.resetLabels();
            }
            catch (ScenarioInitializationException sie) {
                Utility.handleException(sie.getErrorMessage(), true, sie);
            }
        }
    }

    @Override
    public void resetLabels() throws ScenarioInitializationException {
        if (this.actionCopies != null) {
            for (Decorator actionCopy : this.actionCopies) {
                actionCopy.setEnabled(false);
                actionCopy.setGraphDecorated(false);
                if (!(actionCopy instanceof Modifier)) continue;
                Modifier modifier = (Modifier)actionCopy;
                modifier.resetLabels();
            }
        }
        this.getPredicate().reset();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        if (this.getActions() != null) {
            for (Decorator d : this.getActions()) {
                boolean bl = retValue = retValue && d.sane();
            }
        }
        assert (retValue);
        if (this.actionCopies != null) {
            for (Decorator d : this.actionCopies) {
                boolean bl = retValue = retValue && d.sane();
            }
        }
        assert (retValue);
        return retValue;
    }

    @Override
    public Predicate getPredicate() {
        if (this.predicate != null && this.predicate.eIsProxy()) {
            InternalEObject oldPredicate = (InternalEObject)this.predicate;
            this.predicate = (Predicate)this.eResolveProxy(oldPredicate);
            if (this.predicate != oldPredicate && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)oldPredicate, (Object)this.predicate));
            }
        }
        return this.predicate;
    }

    public Predicate basicGetPredicate() {
        return this.predicate;
    }

    @Override
    public void setPredicate(Predicate newPredicate) {
        Predicate oldPredicate = this.predicate;
        this.predicate = newPredicate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldPredicate, (Object)this.predicate));
        }
    }

    @Override
    public EList<Decorator> getActions() {
        if (this.actions == null) {
            this.actions = new EObjectResolvingEList(Decorator.class, (InternalEObject)this, 9);
        }
        return this.actions;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                if (resolve) {
                    return this.getPredicate();
                }
                return this.basicGetPredicate();
            }
            case 9: {
                return this.getActions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setPredicate((Predicate)newValue);
                return;
            }
            case 9: {
                this.getActions().clear();
                this.getActions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setPredicate(null);
                return;
            }
            case 9: {
                this.getActions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.predicate != null;
            }
            case 9: {
                return this.actions != null && !this.actions.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

