/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device;

import java.util.HashMap;
import java.util.Map;

public final class FontUtil {
    public static final String LOGIC_FONT_FAMILY_SERIF = "serif";
    public static final String LOGIC_FONT_FAMILY_SANS_SERIF = "sans-serif";
    public static final String LOGIC_FONT_FAMILY_CURSIVE = "cursive";
    public static final String LOGIC_FONT_FAMILY_FANTASY = "fantasy";
    public static final String LOGIC_FONT_FAMILY_MONOSPACE = "monospace";
    public static final String FONT_FAMILY_COURIER_NEW = "Courier New";
    public static final String FONT_FAMILY_IMPACT = "Impact";
    public static final String FONT_FAMILY_COMIC_SANS_MS = "Comic Sans MS";
    public static final String FONT_FAMILY_ARIAL = "Arial";
    public static final String FONT_FAMILY_TIMES_NEW_ROMAN = "Times New Roman";
    private static Map<String, String> sFamilyMap = new HashMap<String, String>();

    static {
        sFamilyMap.put(LOGIC_FONT_FAMILY_SERIF, FONT_FAMILY_TIMES_NEW_ROMAN);
        sFamilyMap.put(LOGIC_FONT_FAMILY_SANS_SERIF, FONT_FAMILY_ARIAL);
        sFamilyMap.put(LOGIC_FONT_FAMILY_CURSIVE, FONT_FAMILY_COMIC_SANS_MS);
        sFamilyMap.put(LOGIC_FONT_FAMILY_FANTASY, FONT_FAMILY_IMPACT);
        sFamilyMap.put(LOGIC_FONT_FAMILY_MONOSPACE, FONT_FAMILY_COURIER_NEW);
    }

    public static String getFontFamily(String fontFamily) {
        String destFontName = sFamilyMap.get(fontFamily);
        if (destFontName == null) {
            destFontName = fontFamily;
        }
        return destFontName;
    }
}

