/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.launching.OSGiLaunchConfigurationInitializer;

public class EquinoxInitializer
extends OSGiLaunchConfigurationInitializer {
    private Map fStartLevels;

    public void initialize(ILaunchConfigurationWorkingCopy configuration) {
        super.initialize(configuration);
        this.initializeProgramArguments(configuration);
        this.initializeVMArguments(configuration);
        this.initializeTracing(configuration);
    }

    private void initializeProgramArguments(ILaunchConfigurationWorkingCopy configuration) {
        StringBuffer buffer = new StringBuffer(LaunchArgumentsHelper.getInitialProgramArguments());
        if (buffer.length() > 0) {
            if (buffer.indexOf("-console ") == -1 && !buffer.toString().endsWith("-console")) {
                buffer.append(" -console");
            }
        } else {
            buffer.append("-console");
        }
        configuration.setAttribute("append.args", true);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, buffer.toString());
    }

    private void initializeVMArguments(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("pde.version", "3.3");
        PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
        StringBuffer vmArgs = new StringBuffer(preferences.getString("vm_args"));
        if (vmArgs.indexOf("-Declipse.ignoreApp") == -1) {
            if (vmArgs.length() > 0) {
                vmArgs.append(" ");
            }
            vmArgs.append("-Declipse.ignoreApp=true");
        }
        if (vmArgs.indexOf("-Dosgi.noShutdown") == -1) {
            vmArgs.append(" -Dosgi.noShutdown=true");
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs.toString());
    }

    private void initializeTracing(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("checked", "[NONE]");
    }

    protected void initializeBundleState(ILaunchConfigurationWorkingCopy configuration) {
        this.initializeBundleState();
        super.initializeBundleState(configuration);
    }

    protected String getAutoStart(String bundleID) {
        if (this.fStartLevels.containsKey(bundleID)) {
            String value = this.fStartLevels.get(bundleID).toString();
            return value.substring(value.indexOf(":") + 1);
        }
        return super.getAutoStart(bundleID);
    }

    protected String getStartLevel(String bundleID) {
        if (this.fStartLevels.containsKey(bundleID)) {
            String value = this.fStartLevels.get(bundleID).toString();
            return value.substring(0, value.indexOf(":"));
        }
        return super.getStartLevel(bundleID);
    }

    private void initializeBundleState() {
        String value;
        Properties props;
        if (this.fStartLevels == null) {
            this.fStartLevels = new HashMap();
        }
        if ((props = TargetPlatformHelper.getConfigIniProperties()) != null && (value = (String)props.get("osgi.bundles")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String tokenValue = tokenizer.nextToken();
                int index = tokenValue.indexOf("@");
                if (index <= 0) continue;
                String bundle = tokenValue.substring(0, index).trim();
                this.fStartLevels.put(bundle, this.getStartValue(tokenValue.substring(index)));
            }
        }
    }

    private String getStartValue(String value) {
        int colon;
        StringBuffer buffer = new StringBuffer(value);
        StringBuffer result = new StringBuffer(":");
        int index = value.indexOf("start");
        result.append(Boolean.toString(index != -1));
        if (index != -1) {
            buffer.delete(index, index + 5);
        }
        if ((colon = value.indexOf(58)) != -1) {
            buffer.deleteCharAt(colon);
        }
        buffer.deleteCharAt(0);
        try {
            result.insert(0, Integer.parseInt(buffer.toString().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            result.insert(0, "default");
        }
        return result.toString();
    }
}

