/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeNode;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.IndexEntry;
import org.eclipse.birt.core.btree.LeafEntry;
import org.eclipse.birt.core.btree.LeafNode;
import org.eclipse.birt.core.i18n.CoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexNode<K, V>
extends BTreeNode<K, V> {
    static final int EMPTY_NODE_SIZE = 20;
    private int nodeSize = 20;
    private int prevNodeId = -1;
    private int nextNodeId = -1;
    private int firstChild = -1;
    private ArrayList<IndexEntry<K, V>> entries = new ArrayList();

    IndexNode(BTree<K, V> btree, int nodeId) {
        super(btree, 1, nodeId);
    }

    public int getFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(int firstChild) {
        this.firstChild = firstChild;
    }

    public int getPrevNodeId() {
        return this.prevNodeId;
    }

    public void setPrevNodeId(int prevNodeId) {
        this.prevNodeId = prevNodeId;
    }

    public int getNextNodeId() {
        return this.nextNodeId;
    }

    public void setNextNodeId(int nextNodeId) {
        this.nextNodeId = nextNodeId;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public IndexEntry<K, V> getFirstEntry() {
        return this.entries.get(0);
    }

    public IndexEntry<K, V> getLastEntry() {
        return this.entries.get(this.entries.size() - 1);
    }

    public int getLastChild() {
        return this.entries.get(this.entries.size() - 1).getChildNodeId();
    }

    public LeafEntry<K, V> find(BTreeValue<K> key) throws IOException {
        int childNodeId = this.findChildNode(key);
        if (childNodeId != -1) {
            BTreeNode node = this.btree.loadBTreeNode(childNodeId);
            try {
                if (node.nodeType == 1) {
                    LeafEntry<K, V> leafEntry = ((IndexNode)node).find(key);
                    return leafEntry;
                }
                if (node.nodeType == 2) {
                    LeafEntry leafEntry = ((LeafNode)node).find(key);
                    return leafEntry;
                }
                throw new IOException(CoreMessages.getFormattedString("error.UnsupportedNodeType", node.getNodeType(), node.getNodeId()));
            }
            finally {
                node.unlock();
            }
        }
        return null;
    }

    private int search(BTreeValue<K> key) throws IOException {
        return Collections.binarySearch(this.entries, key, new Comparator(){

            public int compare(Object entry, Object key) {
                try {
                    return IndexNode.this.btree.compare(((IndexEntry)entry).getKey(), (BTreeValue)key);
                }
                catch (IOException iOException) {
                    return -1;
                }
            }
        });
    }

    private int findChildNode(BTreeValue<K> key) throws IOException {
        int index = this.search(key);
        if (index >= 0) {
            return this.entries.get(index).getChildNodeId();
        }
        if ((index = -(index + 1)) == 0) {
            return this.firstChild;
        }
        return this.entries.get(index - 1).getChildNodeId();
    }

    public LeafEntry<K, V> insert(BTreeValue<K> key, BTreeValue<V>[] values) throws IOException {
        int childNodeId = this.findChildNode(key);
        if (childNodeId != -1) {
            BTreeNode node = this.btree.loadBTreeNode(childNodeId);
            try {
                if (node.nodeType == 1) {
                    IndexEntry<K, V> splitEntry;
                    IndexNode indexNode = (IndexNode)node;
                    LeafEntry<K, V> insertEntry = indexNode.insert(key, values);
                    if (indexNode.needSplit() && (splitEntry = indexNode.split()) != null) {
                        this.insertIndex(splitEntry.getKey(), splitEntry.getChildNodeId());
                    }
                    LeafEntry<K, V> leafEntry = insertEntry;
                    return leafEntry;
                }
                if (node.nodeType == 2) {
                    IndexEntry splitEntry;
                    LeafNode leafNode = (LeafNode)node;
                    LeafEntry<K, V> insertEntry = leafNode.insert(key, values);
                    if (leafNode.needSplit() && (splitEntry = leafNode.split()) != null) {
                        this.insertIndex(splitEntry.getKey(), splitEntry.getChildNodeId());
                    }
                    LeafEntry<K, V> leafEntry = insertEntry;
                    return leafEntry;
                }
                throw new IOException(CoreMessages.getFormattedString("error.UnsupportedNodeType", node.getNodeType(), childNodeId));
            }
            finally {
                node.unlock();
            }
        }
        return null;
    }

    protected void insertIndex(BTreeValue<K> insertKey, int childNodeId) throws IOException {
        int index = this.search(insertKey);
        assert (index < 0);
        if (index >= 0) {
            throw new IOException("ERROR");
        }
        index = -(index + 1);
        IndexEntry newEntry = new IndexEntry(this, insertKey, childNodeId);
        this.entries.add(index, newEntry);
        this.nodeSize += this.getEntrySize(newEntry);
        this.dirty = true;
    }

    public boolean needSplit() {
        return this.nodeSize > 4088 && this.entries.size() > 13;
    }

    protected void resetNodeSize() {
        this.nodeSize = 20;
        for (IndexEntry<K, V> entry : this.entries) {
            this.nodeSize += this.getEntrySize(entry);
        }
    }

    public IndexEntry<K, V> split() throws IOException {
        int splitIndex = this.entries.size() / 2;
        IndexNode newNode = this.btree.createIndexNode();
        try {
            IndexEntry<K, V> splitEntry = this.entries.get(splitIndex);
            newNode.setFirstChild(splitEntry.getChildNodeId());
            List<IndexEntry<K, V>> splitEntries = this.entries.subList(splitIndex + 1, this.entries.size());
            for (IndexEntry entry : splitEntries) {
                entry.setNode(newNode);
            }
            newNode.entries.addAll(splitEntries);
            newNode.resetNodeSize();
            newNode.setPrevNodeId(this.nodeId);
            newNode.setNextNodeId(this.nextNodeId);
            if (this.nextNodeId != -1) {
                IndexNode nextNode = this.btree.loadIndexNode(this.nextNodeId);
                try {
                    nextNode.setPrevNodeId(newNode.getNodeId());
                    nextNode.setDirty(true);
                }
                finally {
                    nextNode.unlock();
                }
            }
            this.nextNodeId = newNode.getNodeId();
            ArrayList<IndexEntry<K, V>> remainEntries = new ArrayList<IndexEntry<K, V>>();
            remainEntries.addAll(this.entries.subList(0, splitIndex));
            this.entries = remainEntries;
            this.resetNodeSize();
            IndexEntry indexEntry = new IndexEntry(this, splitEntry.getKey(), newNode.getNodeId());
            return indexEntry;
        }
        finally {
            newNode.unlock();
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.nodeSize = in.readInt();
        this.prevNodeId = in.readInt();
        this.nextNodeId = in.readInt();
        int entryCount = in.readInt();
        this.firstChild = in.readInt();
        this.entries.clear();
        this.entries.ensureCapacity(entryCount);
        int i = 0;
        while (i < entryCount) {
            IndexEntry<K, V> entry = this.readEntry(in);
            this.entries.add(entry);
            ++i;
        }
    }

    @Override
    protected void write(DataOutput out) throws IOException {
        out.writeInt(this.nodeSize);
        out.writeInt(this.prevNodeId);
        out.writeInt(this.nextNodeId);
        out.writeInt(this.entries.size());
        out.writeInt(this.firstChild);
        for (IndexEntry<K, V> entry : this.entries) {
            this.writeEntry(out, entry);
        }
    }

    private IndexEntry<K, V> readEntry(DataInput in) throws IOException {
        BTreeValue key = this.btree.readKey(in);
        int childNodeId = in.readInt();
        return new IndexEntry(this, key, childNodeId);
    }

    private void writeEntry(DataOutput out, IndexEntry<K, V> entry) throws IOException {
        this.btree.writeKey(out, entry.getKey());
        out.writeInt(entry.getChildNodeId());
    }

    private int getEntrySize(IndexEntry<K, V> entry) {
        return 4 + this.btree.getKeySize(entry.getKey());
    }

    @Override
    public void dumpNode() throws IOException {
        System.out.println("INDEX:" + this.nodeId);
        System.out.println("nodeSize:" + this.nodeSize);
        System.out.println("prevNodeId:" + this.prevNodeId);
        System.out.println("nextNodeId :" + this.nextNodeId);
        System.out.println("entryCount:" + this.entries.size());
        System.out.print(this.firstChild);
        for (IndexEntry<K, V> entry : this.entries) {
            System.out.print("<<[");
            System.out.print(this.btree.getKey(entry.getKey()));
            System.out.print("]<<");
            System.out.print(entry.getChildNodeId());
        }
        System.out.println();
    }

    @Override
    public void dumpAll() throws IOException {
        this.dumpNode();
        BTreeNode node = this.btree.loadBTreeNode(this.firstChild);
        try {
            node.dumpAll();
        }
        finally {
            node.unlock();
        }
        for (IndexEntry<K, V> entry : this.entries) {
            node = this.btree.loadBTreeNode(entry.getChildNodeId());
            try {
                node.dumpAll();
            }
            finally {
                node.unlock();
            }
        }
    }
}

