/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.util.AbstractReentrantTypeReferenceProvider;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameter;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XtypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedTypes
implements IResolvedTypes {
    private Map<JvmIdentifiableElement, JvmTypeReference> types;
    private Map<JvmIdentifiableElement, JvmTypeReference> reassignedTypes;
    private Multimap<XExpression, TypeData> expressionTypes;
    private Map<XExpression, ILinkingCandidate> featureLinking;
    private final DefaultReentrantTypeResolver resolver;

    protected ResolvedTypes(DefaultReentrantTypeResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public List<Diagnostic> getQueuedDiagnostics() {
        throw new UnsupportedOperationException("TODO implement me");
    }

    protected TypeData getTypeData(XExpression expression, boolean returnType) {
        Collection values = this.ensureExpressionTypesMapExists().get((Object)expression);
        if (values.isEmpty()) {
            return null;
        }
        TypeData result = this.mergeTypeData(expression, values, returnType);
        return result;
    }

    protected TypeData mergeTypeData(final XExpression expression, Collection<TypeData> allValues, final boolean returnType) {
        ArrayList values = Lists.newArrayListWithCapacity((int)allValues.size());
        for (TypeData value : values) {
            if (returnType != value.isReturnType()) continue;
            values.add(value);
        }
        if (values.size() == 1) {
            TypeData typeData = (TypeData)values.iterator().next();
            return typeData;
        }
        final XComputedTypeReference mergedType = this.getXtypeFactory().createXComputedTypeReference();
        mergedType.setTypeProvider(new AbstractReentrantTypeReferenceProvider(){

            protected JvmTypeReference doGetTypeReference() {
                Collection freshlyObtainedValues = ResolvedTypes.this.ensureExpressionTypesMapExists().get((Object)expression);
                ArrayList references = Lists.newArrayList();
                for (TypeData value : freshlyObtainedValues) {
                    JvmTypeReference reference = value.getActualType();
                    if (returnType != value.isReturnType() || !ResolvedTypes.this.isValidForMergedResult(reference, (JvmTypeReference)mergedType)) continue;
                    references.add(reference);
                }
                return ResolvedTypes.this.getCommonType(references);
            }
        });
        TypeData result = new TypeData(expression, null, (JvmTypeReference)mergedType, ConformanceHint.MERGED, returnType);
        return result;
    }

    protected XtypeFactory getXtypeFactory() {
        return this.getResolver().getServices().getXtypeFactory();
    }

    protected boolean isValidForMergedResult(JvmTypeReference reference, JvmTypeReference mayNotBe) {
        if (reference == mayNotBe || reference == null) {
            return false;
        }
        if (reference instanceof JvmDelegateTypeReference) {
            return this.isValidForMergedResult(((JvmDelegateTypeReference)reference).getDelegate(), mayNotBe);
        }
        if (reference instanceof JvmCompoundTypeReference) {
            EList components = ((JvmCompoundTypeReference)reference).getReferences();
            if (components.isEmpty()) {
                return false;
            }
            for (JvmTypeReference component : components) {
                if (this.isValidForMergedResult(component, mayNotBe)) continue;
                return false;
            }
        }
        if (reference instanceof JvmSpecializedTypeReference) {
            return this.isValidForMergedResult(((JvmSpecializedTypeReference)reference).getEquivalent(), mayNotBe);
        }
        return true;
    }

    protected JvmTypeReference getCommonType(List<JvmTypeReference> types) {
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1) {
            JvmTypeReference result = types.get(0);
            return result;
        }
        JvmTypeReference result = this.getTypeConformanceComputer().getCommonSuperType(types);
        if (result != null || types.isEmpty()) {
            return result;
        }
        for (JvmTypeReference type : types) {
            if (this.resolver.getServices().getTypeReferences().is(type, Void.TYPE)) continue;
            return type;
        }
        return types.get(0);
    }

    protected TypeConformanceComputer getTypeConformanceComputer() {
        return this.getResolver().getServices().getTypeConformanceComputer();
    }

    @Override
    public JvmTypeReference getActualType(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, false);
        if (typeData != null) {
            return typeData.getActualType();
        }
        return null;
    }

    @Override
    public JvmTypeReference getExpectedType(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, false);
        if (typeData != null) {
            return typeData.getExpectation().getExpectedType();
        }
        return null;
    }

    @Override
    public List<JvmTypeReference> getActualTypeArguments(XExpression expression) {
        throw new UnsupportedOperationException("TODO implement me");
    }

    public void setType(JvmIdentifiableElement identifiable, JvmTypeReference reference) {
        this.ensureTypesMapExists().put(identifiable, reference);
    }

    public void reassignType(JvmIdentifiableElement identifiable, JvmTypeReference reference) {
        if (reference != null) {
            JvmTypeReference actualType = this.getActualType(identifiable);
            if (!this.getTypeConformanceComputer().isConformant(reference, actualType)) {
                if (this.getTypeConformanceComputer().isConformant(actualType, reference)) {
                    this.ensureReassignedTypesMapExists().put(identifiable, reference);
                } else {
                    JvmMultiTypeReference multiTypeReference = TypesFactory.eINSTANCE.createJvmMultiTypeReference();
                    if (actualType instanceof JvmMultiTypeReference) {
                        for (JvmTypeReference component : ((JvmMultiTypeReference)actualType).getReferences()) {
                            multiTypeReference.getReferences().add((Object)((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)component)));
                        }
                    } else {
                        multiTypeReference.getReferences().add((Object)((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)actualType)));
                    }
                    multiTypeReference.getReferences().add((Object)((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)reference)));
                    this.ensureReassignedTypesMapExists().put(identifiable, (JvmTypeReference)multiTypeReference);
                }
            }
        } else {
            this.ensureReassignedTypesMapExists().remove(identifiable);
        }
    }

    protected JvmTypeReference acceptType(final XExpression expression, AbstractTypeExpectation expectation, JvmTypeReference type, ConformanceHint conformanceHint, boolean returnType) {
        TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(Collections.emptyMap(), this.resolver.getServices()){

            @Override
            protected JvmTypeReference getUnmappedSubstitute(JvmParameterizedTypeReference reference, JvmTypeParameter type, Set<JvmTypeParameter> visiting) {
                if (expression instanceof XAbstractFeatureCall || expression instanceof XConstructorCall || expression instanceof XClosure) {
                    XComputedTypeReference result = this.getServices().getXtypeFactory().createXComputedTypeReference();
                    result.setTypeProvider(new UnboundTypeParameter(expression, type, this.getServices()));
                    return result;
                }
                throw new IllegalStateException("expression was: " + expression);
            }

            @Override
            public JvmTypeReference doVisitComputedTypeReference(final XComputedTypeReference reference, Set<JvmTypeParameter> visiting) {
                JvmTypeReference equivalent = (JvmTypeReference)reference.eGet((EStructuralFeature)TypesPackage.Literals.JVM_SPECIALIZED_TYPE_REFERENCE__EQUIVALENT, false);
                if (equivalent != null) {
                    return (JvmTypeReference)this.visit(equivalent, visiting);
                }
                XComputedTypeReference result = this.getServices().getXtypeFactory().createXComputedTypeReference();
                if (reference.getTypeProvider() instanceof UnboundTypeParameter) {
                    result.setTypeProvider(reference.getTypeProvider());
                } else {
                    result.setTypeProvider(new AbstractReentrantTypeReferenceProvider(){

                        protected JvmTypeReference doGetTypeReference() {
                            JvmTypeReference originalEquivalent = reference.getEquivalent();
                            JvmTypeReference result = this.substitute(originalEquivalent);
                            return result;
                        }
                    });
                }
                return result;
            }
        };
        JvmTypeReference actualType = substitutor.substitute(type);
        this.ensureExpressionTypesMapExists().put((Object)expression, (Object)new TypeData(expression, expectation, actualType, conformanceHint, returnType));
        return actualType;
    }

    protected Map<JvmIdentifiableElement, JvmTypeReference> ensureTypesMapExists() {
        if (this.types == null) {
            this.types = Maps.newHashMap();
        }
        return this.types;
    }

    protected Map<JvmIdentifiableElement, JvmTypeReference> ensureReassignedTypesMapExists() {
        if (this.reassignedTypes == null) {
            this.reassignedTypes = Maps.newHashMap();
        }
        return this.reassignedTypes;
    }

    protected Multimap<XExpression, TypeData> ensureExpressionTypesMapExists() {
        if (this.expressionTypes == null) {
            this.expressionTypes = HashMultimap.create((int)2, (int)2);
        }
        return this.expressionTypes;
    }

    protected Map<XExpression, ILinkingCandidate> ensureLinkingMapExists() {
        if (this.featureLinking == null) {
            this.featureLinking = Maps.newHashMap();
        }
        return this.featureLinking;
    }

    @Override
    public JvmTypeReference getActualType(JvmIdentifiableElement identifiable) {
        JvmTypeReference result;
        if (this.reassignedTypes != null && (result = this.reassignedTypes.get(identifiable)) != null) {
            return result;
        }
        if (this.types == null) {
            return this.getDeclaredType(identifiable);
        }
        result = this.ensureTypesMapExists().get(identifiable);
        if (result == null) {
            return this.getDeclaredType(identifiable);
        }
        return result;
    }

    protected JvmTypeReference getDeclaredType(JvmIdentifiableElement identifiable) {
        if (identifiable instanceof JvmOperation) {
            return ((JvmOperation)identifiable).getReturnType();
        }
        if (identifiable instanceof JvmField) {
            return ((JvmField)identifiable).getType();
        }
        if (identifiable instanceof JvmConstructor) {
            return this.resolver.getServices().getTypeReferences().createTypeRef((JvmType)((JvmConstructor)identifiable).getDeclaringType(), new JvmTypeReference[0]);
        }
        return null;
    }

    public IFeatureLinkingCandidate getFeature(XAbstractFeatureCall featureCall) {
        return (IFeatureLinkingCandidate)this.ensureLinkingMapExists().get(featureCall);
    }

    public IConstructorLinkingCandidate getConstructor(XConstructorCall constructorCall) {
        return (IConstructorLinkingCandidate)this.ensureLinkingMapExists().get(constructorCall);
    }

    public void acceptLinkingInformation(XExpression expression, ILinkingCandidate candidate) {
        this.ensureLinkingMapExists().put(expression, candidate);
    }

    protected DefaultReentrantTypeResolver getResolver() {
        return this.resolver;
    }
}

