/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.loggers.IdentifierProperty;
import org.eclipse.stem.loggers.LOGGER_EVENTS;
import org.eclipse.stem.loggers.SimulationLoggerEvent;
import org.eclipse.stem.loggers.SimulationLoggerFactory;
import org.eclipse.stem.loggers.SimulationLoggerPackage;
import org.eclipse.stem.loggers.impl.IdentifierPropertyImpl;
import org.eclipse.stem.loggers.impl.SimulationLoggerEventImpl;

public class SimulationLoggerFactoryImpl
extends EFactoryImpl
implements SimulationLoggerFactory {
    public static final String copyright = "Copyright (c) 2011 IBM Corporation and others.\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n    IBM Corporation - initial API and implementation";

    public static SimulationLoggerFactory init() {
        try {
            SimulationLoggerFactory theSimulationLoggerFactory = (SimulationLoggerFactory)EPackage.Registry.INSTANCE.getEFactory("http://org/eclipse/stem/loggers/");
            if (theSimulationLoggerFactory != null) {
                return theSimulationLoggerFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SimulationLoggerFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 4: {
                return this.createSimulationLoggerEvent();
            }
            case 6: {
                return this.createIdentifierProperty();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.createLOGGER_EVENTSFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createSimulationEventFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.convertLOGGER_EVENTSToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertSimulationEventToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public SimulationLoggerEvent createSimulationLoggerEvent() {
        SimulationLoggerEventImpl simulationLoggerEvent = new SimulationLoggerEventImpl();
        return simulationLoggerEvent;
    }

    @Override
    public IdentifierProperty createIdentifierProperty() {
        IdentifierPropertyImpl identifierProperty = new IdentifierPropertyImpl();
        return identifierProperty;
    }

    public LOGGER_EVENTS createLOGGER_EVENTSFromString(EDataType eDataType, String initialValue) {
        LOGGER_EVENTS result = LOGGER_EVENTS.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertLOGGER_EVENTSToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public SimulationEvent createSimulationEventFromString(EDataType eDataType, String initialValue) {
        return (SimulationEvent)super.createFromString(eDataType, initialValue);
    }

    public String convertSimulationEventToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public SimulationLoggerPackage getSimulationLoggerPackage() {
        return (SimulationLoggerPackage)this.getEPackage();
    }

    @Deprecated
    public static SimulationLoggerPackage getPackage() {
        return SimulationLoggerPackage.eINSTANCE;
    }
}

