/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;

public class StemPolygon {
    public double[] points = null;
    public int[] transformedPoints = null;
    private Identifiable identifiable;
    private double valueToDisplay;
    private double minX = Double.POSITIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;
    private double area;

    public StemPolygon(LatLong.Segment latLongSegment, Identifiable identifiable) {
        int size = latLongSegment.size();
        this.identifiable = identifiable;
        this.valueToDisplay = Double.NaN;
        this.points = new double[2 * size];
        this.area = 0.0;
        int i = 0;
        while (i < size) {
            double x1 = latLongSegment.longitude(i);
            double y1 = latLongSegment.latitude(i);
            this.points[2 * i] = x1;
            this.points[2 * i + 1] = y1;
            this.maxX = Math.max(x1, this.maxX);
            this.maxY = Math.max(y1, this.maxY);
            this.minX = Math.min(x1, this.minX);
            this.minY = Math.min(y1, this.minY);
            if (i < size - 1) {
                double x2 = latLongSegment.longitude(i + 1);
                double y2 = latLongSegment.latitude(i + 1);
                this.area += x1 * y2 - x2 * y1;
            }
            ++i;
        }
        this.area = Math.abs(this.area / 2.0);
    }

    public void computeTransformedPoints(double offsetX, double offsetY, double scaleX, double scaleY) {
        this.transformedPoints = new int[this.getNumberOfPoints() * 2];
        int i = 0;
        while (i < this.getNumberOfPoints()) {
            this.transformedPoints[2 * i] = (int)(this.points[2 * i] * scaleX + offsetX);
            this.transformedPoints[2 * i + 1] = (int)(this.points[2 * i + 1] * scaleY + offsetY);
            ++i;
        }
    }

    public Identifiable getIdentifiable() {
        return this.identifiable;
    }

    public double getValueToDisplay() {
        return this.valueToDisplay;
    }

    public void setValueToDisplay(double valueToDisplay) {
        this.valueToDisplay = valueToDisplay;
    }

    public Rectangle2D.Double getBounds() {
        if (this.minX == 2.147483647E9 || this.maxX == -2.147483648E9 || this.minY == 2.147483647E9 || this.maxY == -2.147483648E9) {
            return null;
        }
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public double getArea() {
        return this.area;
    }

    public boolean containsPoint(Point2D.Double point) {
        int n = this.getNumberOfPoints();
        double[] xs = new double[n];
        double[] ys = new double[n];
        double x = point.x;
        double y = point.y;
        int i = 0;
        while (i < n) {
            xs[i] = this.points[2 * i];
            ys[i] = this.points[2 * i + 1];
            ++i;
        }
        int hits = 0;
        double x1 = xs[n - 1];
        double y1 = ys[n - 1];
        int i2 = 0;
        while (i2 < n) {
            double xProjection;
            double x2 = xs[i2];
            double y2 = ys[i2];
            if (y == y2) {
                double y3;
                if (x < x2 && y > Math.min(y1, y3 = ys[(i2 + 1) % n]) && y < Math.max(y1, y3)) {
                    ++hits;
                }
            } else if (y > Math.min(y1, y2) && y < Math.max(y1, y2) && x < (xProjection = (x2 - x1) / (y2 - y1) * (y - y1) + x1)) {
                ++hits;
            }
            x1 = x2;
            y1 = y2;
            ++i2;
        }
        return hits % 2 != 0;
    }

    public int getNumberOfPoints() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length / 2;
    }

    public boolean isSquare() {
        if (this.getNumberOfPoints() != 5) {
            return false;
        }
        Point2D.Double p1 = new Point2D.Double(this.points[0], this.points[1]);
        Point2D.Double p2 = new Point2D.Double(this.points[2], this.points[3]);
        Point2D.Double p3 = new Point2D.Double(this.points[4], this.points[5]);
        Point2D.Double p4 = new Point2D.Double(this.points[6], this.points[7]);
        double d1 = p1.distance(p2);
        double d2 = p2.distance(p3);
        double d3 = p3.distance(p4);
        double d4 = p4.distance(p1);
        double dot = (p2.x - p1.x) * (p3.x - p2.x) + (p2.y - p1.y) * (p3.y - p2.y);
        return Math.abs(d1 - d2) < 0.01 && Math.abs(d2 - d3) < 0.01 && Math.abs(d3 - d4) < 0.01 && Math.abs(dot) < 0.01;
    }
}

