/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.ITextRegion;

public class DefaultRenameStrategy
extends AbstractRenameStrategy {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IValueConverterService valueConverterService;
    protected ITextRegion originalNameRegion;
    protected String nameRuleName;

    public boolean initialize(EObject targetElement, IRenameElementContext context) {
        if (super.initialize(targetElement, context)) {
            this.originalNameRegion = this.getOriginalNameRegion(targetElement, this.getNameAttribute());
            this.nameRuleName = this.getNameRuleName(targetElement, this.getNameAttribute());
            return true;
        }
        return false;
    }

    protected ITextRegion getOriginalNameRegion(EObject targetElement, EAttribute nameAttribute) {
        return this.locationInFileProvider.getFullTextRegion(targetElement, (EStructuralFeature)nameAttribute, 0);
    }

    protected String getNameRuleName(EObject targetElement, EAttribute nameAttribute) {
        List nameNodes = NodeModelUtils.findNodesForFeature((EObject)targetElement, (EStructuralFeature)nameAttribute);
        if (nameNodes.size() != 1 || !(((INode)nameNodes.get(0)).getGrammarElement() instanceof RuleCall)) {
            return null;
        }
        return ((RuleCall)((INode)nameNodes.get(0)).getGrammarElement()).getRule().getName();
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        updateAcceptor.accept(this.getTargetElementOriginalURI().trimFragment(), this.getDeclarationTextEdit(newName));
    }

    protected TextEdit getDeclarationTextEdit(String newName) {
        String text = newName;
        return new ReplaceEdit(this.originalNameRegion.getOffset(), this.originalNameRegion.getLength(), text);
    }

    protected String getNameAsText(String nameAsValue) {
        return this.nameRuleName != null ? this.valueConverterService.toString((Object)nameAsValue, this.nameRuleName) : nameAsValue;
    }

    protected String getNameAsValue(String nameAsText) {
        return this.nameRuleName != null ? this.valueConverterService.toValue(nameAsText, this.nameRuleName, null).toString() : nameAsText;
    }

    public String getOriginalName() {
        return this.getNameAsText(super.getOriginalName());
    }

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        super.applyDeclarationChange(this.getNameAsValue(newName), resourceSet);
    }
}

