/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ViewSettingsDialog;

public abstract class ViewerSettingsAndStatusDialog
extends ViewSettingsDialog {
    private Label imageLabel;
    private Text messageArea;
    private Composite msgParent;

    public ViewerSettingsAndStatusDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += this.convertHeightInCharsToPixels(3);
        return size;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new GridLayout(1, true));
        this.initializeDialogUnits((Control)dialogArea);
        this.createMessageArea(dialogArea).setLayoutData((Object)new GridData(4, 0, true, false));
        this.createDialogContentArea(dialogArea).setLayoutData((Object)new GridData(4, 4, true, true));
        ViewerSettingsAndStatusDialog.applyDialogFont((Control)dialogArea);
        this.initializeDialog();
        return dialogArea;
    }

    protected abstract Control createDialogContentArea(Composite var1);

    protected void initializeDialog() {
        this.handleStatusUdpate(1, this.getDefaultMessage());
    }

    Control createMessageArea(Composite parent) {
        this.msgParent = new Composite(parent, 2048);
        this.msgParent.setBackground(this.getMessageBackground());
        this.msgParent.setLayout((Layout)new GridLayout(2, false));
        this.imageLabel = new Label(this.msgParent, 0);
        this.imageLabel.setBackground(this.msgParent.getBackground());
        this.imageLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        this.imageLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.messageArea = new Text(this.msgParent, 586);
        this.messageArea.setEditable(false);
        this.messageArea.setBackground(this.msgParent.getBackground());
        this.messageArea.setLayoutData((Object)new GridData(4, 4, true, true));
        return this.msgParent;
    }

    protected void handleStatusUdpate(IStatus status) {
        this.handleStatusUdpate(status.getSeverity(), status.getMessage());
    }

    protected void handleStatusUdpate(int severity, String messgage) {
        Image image = null;
        Button okBttn = this.getButton(0);
        switch (severity) {
            case 4: {
                if (messgage == null) {
                    messgage = this.getErrorMessage();
                }
                image = this.getErrorImage();
                break;
            }
            case 2: {
                image = this.getWarningImage();
                break;
            }
            default: {
                image = this.getInfoImage();
            }
        }
        if (messgage == null) {
            messgage = this.getDefaultMessage();
        }
        if (messgage.equals("")) {
            this.handleMessageAreaVisibility(false);
            image = null;
        } else {
            this.handleMessageAreaVisibility(true);
        }
        if (okBttn != null) {
            okBttn.setEnabled(severity == 0 || severity == 1 || severity == 2);
        }
        if (this.msgParent != null) {
            this.setMessageImage(image);
            this.setMessageText(messgage);
            this.msgParent.layout();
        }
    }

    protected void setMessageImage(Image image) {
        if (this.imageLabel != null) {
            this.imageLabel.setImage(image);
        }
    }

    protected void setMessageText(String messgage) {
        if (this.messageArea != null) {
            this.messageArea.setText(messgage);
        }
    }

    protected Image getMessageImage() {
        if (this.imageLabel != null) {
            this.imageLabel.getImage();
        }
        return null;
    }

    protected String getMessageText() {
        if (this.messageArea != null) {
            return this.messageArea.getText();
        }
        return null;
    }

    protected void handleMessageAreaVisibility(boolean visible) {
        if (this.msgParent == null || this.msgParent.isDisposed()) {
            return;
        }
        GridData data = (GridData)this.msgParent.getLayoutData();
        if (data.exclude == visible) {
            data.exclude = !visible;
            this.msgParent.setVisible(visible);
            this.msgParent.getParent().layout();
        }
    }

    protected Color getMessageBackground() {
        return this.getShell().getDisplay().getSystemColor(25);
    }

    protected String getDefaultMessage() {
        return "";
    }

    protected String getErrorMessage() {
        return JFaceResources.getString((String)"StringFieldEditor.errorMessage");
    }

    protected Image getInfoImage() {
        return JFaceResources.getImage((String)"dialog_messasge_info_image");
    }

    protected Image getWarningImage() {
        return JFaceResources.getImage((String)"dialog_messasge_warning_image");
    }

    protected Image getErrorImage() {
        return JFaceResources.getImage((String)"dialog_message_error_image");
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }
}

