/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.preferences;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;

@Singleton
public class BuilderPreferenceAccess {
    public static final String PREF_AUTO_BUILDING = "autobuilding";
    private IPreferenceStoreAccess preferenceStoreAccess;

    public static String getKey(OutputConfiguration outputConfiguration, String preferenceName) {
        return "outlet." + outputConfiguration.getName() + '.' + preferenceName;
    }

    @Inject
    public void setPreferenceStoreAccess(IPreferenceStoreAccess preferenceStoreAccess) {
        this.preferenceStoreAccess = preferenceStoreAccess;
    }

    public boolean isAutoBuildEnabled(Object context) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getContextPreferenceStore(context);
        return preferenceStore.contains(PREF_AUTO_BUILDING) ? preferenceStore.getBoolean(PREF_AUTO_BUILDING) : true;
    }

    public void setAutoBuildEnabled(Object context, boolean enabled) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getWritablePreferenceStore(context);
        preferenceStore.setValue(PREF_AUTO_BUILDING, enabled);
    }

    public static class Initializer
    implements IPreferenceStoreInitializer {
        private IOutputConfigurationProvider outputConfigurationProvider;

        public IOutputConfigurationProvider getOutputConfigurationProvider() {
            return this.outputConfigurationProvider;
        }

        @Inject
        public void setOutputConfigurationProvider(IOutputConfigurationProvider outputConfigurationProvider) {
            this.outputConfigurationProvider = outputConfigurationProvider;
        }

        public void initialize(IPreferenceStoreAccess preferenceStoreAccess) {
            IPreferenceStore store = preferenceStoreAccess.getWritablePreferenceStore();
            this.intializeBuilderPreferences(store);
            this.initializeOutputPreferences(store);
        }

        private void intializeBuilderPreferences(IPreferenceStore store) {
            store.setDefault(BuilderPreferenceAccess.PREF_AUTO_BUILDING, true);
        }

        private void initializeOutputPreferences(IPreferenceStore store) {
            for (OutputConfiguration configuration : this.outputConfigurationProvider.getOutputConfigurations()) {
                store.setDefault(BuilderPreferenceAccess.getKey(configuration, "name"), configuration.getName());
                store.setDefault(BuilderPreferenceAccess.getKey(configuration, "description"), configuration.getDescription());
                store.setDefault(BuilderPreferenceAccess.getKey(configuration, "derived"), configuration.isSetDerivedProperty());
                store.setDefault(BuilderPreferenceAccess.getKey(configuration, "directory"), configuration.getOutputDirectory());
                store.setDefault(BuilderPreferenceAccess.getKey(configuration, "createDirectory"), configuration.isCreateOutputDirectory());
                store.setDefault(BuilderPreferenceAccess.getKey(configuration, "cleanDirectory"), configuration.isCanClearOutputDirectory());
                store.setDefault(BuilderPreferenceAccess.getKey(configuration, "override"), configuration.isOverrideExistingResources());
                store.setDefault(BuilderPreferenceAccess.getKey(configuration, "cleanupDerived"), configuration.isCleanUpDerivedResources());
            }
        }
    }
}

