/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.fd.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.solvers.fd.impl.FiniteDifferenceImpl;

public class FdJob
extends Job {
    public static final String JOB_PLUGIN_ID = "org.eclipse.stem.solvers.fd";
    public static final int JOB_ERROR_CODE = 2;
    public static int COMPUTE_DELTAS = 0;
    public static int CHECK_DELTAS = 1;
    public static int APPLY_DELTAS = 2;
    protected double adjustmentFactor = 1.0;
    protected double progress;
    protected double t;
    protected FiniteDifferenceImpl solver;
    protected STEMTime time;
    long timeDelta;
    int cycle;
    short threadnum;
    int step;

    public FdJob(String n, short thread, FiniteDifferenceImpl s) {
        super(n);
        this.threadnum = thread;
        this.solver = s;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double p) {
        this.progress = p;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.CANCEL_STATUS;
        try {
            if (this.step == COMPUTE_DELTAS) {
                this.solver.computeDeltasStep(this.time, this.t, this.timeDelta, this.threadnum);
                status = new Status(0, "unknownId", "");
            } else if (this.step == CHECK_DELTAS) {
                this.adjustmentFactor = this.solver.checkDeltasStep(this.threadnum);
                status = new Status(0, "unknownId", "");
            } else if (this.step == APPLY_DELTAS) {
                this.solver.applyDeltasStep(this.threadnum, this.timeDelta);
                status = new Status(0, "unknownId", "");
            }
        }
        catch (Throwable t) {
            return new Status(8, JOB_PLUGIN_ID, 2, t.getMessage(), t);
        }
        return status;
    }
}

