/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.IHandlerService;

public class OpenExternalDocAction
extends Action
implements IEditorActionDelegate {
    private static final String COMMAND_ID = "org.eclipse.ant.ui.openExternalDoc";
    private AntEditor fEditor;
    static /* synthetic */ Class class$0;

    public OpenExternalDocAction() {
    }

    public OpenExternalDocAction(AntEditor antEditor) {
        this.fEditor = antEditor;
        this.setActionDefinitionId(COMMAND_ID);
        IWorkbenchPartSite iWorkbenchPartSite = antEditor.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbenchPartSite.getService((Class)clazz);
        handlerService.activateHandler(COMMAND_ID, (IHandler)new ActionHandler((IAction)this));
        this.setText(AntEditorActionMessages.getString("OpenExternalDocAction.1"));
        this.setDescription(AntEditorActionMessages.getString("OpenExternalDocAction.2"));
        this.setToolTipText(AntEditorActionMessages.getString("OpenExternalDocAction.2"));
    }

    private Shell getShell() {
        return this.fEditor.getEditorSite().getShell();
    }

    private void doAction(AntElementNode node) {
        Shell shell = this.getShell();
        try {
            URL url = this.getExternalLocation(node);
            if (url != null) {
                AntUtil.openBrowser(url.toString(), shell, this.getTitle());
            }
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
        }
    }

    public URL getExternalLocation(AntElementNode node) throws MalformedURLException {
        URL baseLocation = this.getBaseLocation();
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer pathBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            pathBuffer.append('/');
        }
        if (node instanceof AntProjectNode) {
            pathBuffer.append("using.html#projects");
        } else if (node instanceof AntTargetNode) {
            if (((AntTargetNode)node).isExtensionPoint()) {
                pathBuffer.append("targets.html#extension-points");
            } else {
                pathBuffer.append("using.html#targets");
            }
        } else if (node instanceof AntTaskNode) {
            AntTaskNode taskNode = (AntTaskNode)node;
            if (this.fEditor.getAntModel().getDefininingTaskNode(taskNode.getTask().getTaskName()) == null) {
                this.appendTaskPath(taskNode, pathBuffer);
            }
        }
        try {
            return new URL(pathBuffer.toString());
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
            return null;
        }
    }

    private void appendTaskPath(AntTaskNode node, StringBuffer buffer) {
        String taskName = node.getTask().getTaskName();
        String taskPart = null;
        if (taskName.equalsIgnoreCase("path")) {
            buffer.append("using.html#path");
            return;
        }
        taskPart = this.getTaskTypePart(node);
        if (taskPart == null) {
            return;
        }
        buffer.append(taskPart);
        buffer.append('/');
        buffer.append(taskName);
        buffer.append(".html");
    }

    private URL getBaseLocation() throws MalformedURLException {
        IPreferenceStore prefs = AntUIPlugin.getDefault().getPreferenceStore();
        String base = prefs.getString("documentation.url");
        return new URL(base);
    }

    private String getTitle() {
        return AntEditorActionMessages.getString("OpenExternalDocAction.0");
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = (AntEditor)targetEditor;
        if (this.fEditor != null) {
            IWorkbenchPartSite iWorkbenchPartSite = this.fEditor.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IHandlerService handlerService = (IHandlerService)iWorkbenchPartSite.getService((Class)clazz);
            handlerService.activateHandler(COMMAND_ID, (IHandler)new ActionHandler((IAction)this));
        }
    }

    public void run(IAction action) {
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        AntElementNode node = null;
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int textOffset = textSelection.getOffset();
            AntModel model = this.fEditor.getAntModel();
            if (model != null) {
                node = model.getNode(textOffset, false);
            }
            if (node != null) {
                this.doAction(node);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private String getTaskTypePart(AntTaskNode node) {
        AntProjectNode projectNode = node.getProjectNode();
        if (projectNode != null) {
            Project antProject = projectNode.getProject();
            AntTypeDefinition definition = ComponentHelper.getComponentHelper((Project)antProject).getDefinition(node.getTask().getTaskName());
            if (definition == null) {
                return null;
            }
            String className = definition.getClassName();
            if (className.indexOf("taskdef") != -1) {
                return "Tasks";
            }
            return "Types";
        }
        return null;
    }

    public void run() {
        this.run(null);
    }
}

