/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

public class RemoveAllBreakpointsAction
extends AbstractRemoveAllActionDelegate
implements IBreakpointsListener {
    private Shell fShell;

    protected boolean isEnabled() {
        return DebugPlugin.getDefault().getBreakpointManager().hasBreakpoints();
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        this.update();
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.getAction() != null) {
            this.update();
        }
    }

    protected void initialize() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        super.dispose();
    }

    public void run(IAction action) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        final IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        if (breakpoints.length < 1) {
            return;
        }
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean prompt = store.getBoolean("org.eclipse.debug.ui.remove_all_breakpoints_prompt");
        boolean proceed = true;
        if (prompt) {
            MessageDialogWithToggle mdwt = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ActionMessages.RemoveAllBreakpointsAction_0, (String)ActionMessages.RemoveAllBreakpointsAction_1, (String)ActionMessages.RemoveAllBreakpointsAction_3, (!prompt ? 1 : 0) != 0, null, null);
            if (mdwt.getReturnCode() != 2) {
                proceed = false;
            } else {
                store.setValue("org.eclipse.debug.ui.remove_all_breakpoints_prompt", !mdwt.getToggleState());
            }
        }
        if (proceed) {
            new Job(ActionMessages.RemoveAllBreakpointsAction_2){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        DebugUITools.deleteBreakpoints(breakpoints, RemoveAllBreakpointsAction.this.fShell, monitor);
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void init(IViewPart view) {
        super.init(view);
        this.fShell = view.getSite().getShell();
    }

    public void init(IWorkbenchWindow window) {
        super.init(window);
        this.fShell = window.getShell();
    }
}

