/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.imagewriter.logger;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.loggers.common.Constants;
import org.eclipse.stem.loggers.common.FileUtils;
import org.eclipse.stem.loggers.imagewriter.Activator;
import org.eclipse.stem.loggers.imagewriter.ProjectedMapImageLogger;
import org.eclipse.stem.loggers.imagewriter.logger.DecoratorIdentifierProperty;
import org.eclipse.stem.loggers.imagewriter.logger.Messages;
import org.eclipse.stem.loggers.imagewriter.logger.draw.MapDrawer;
import org.eclipse.stem.loggers.imagewriter.logger.projections.Equirectangular;
import org.eclipse.stem.loggers.imagewriter.logger.projections.IMapProjection;
import org.eclipse.stem.ui.adapters.color.AbstractRelativeValueColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;

public class DecoratorPropertyImageWriter {
    private ProjectedMapImageLogger logger;
    private ISimulation simulation;
    private IMapProjection projection;
    private static final String imageFormat = "png";
    private boolean initialized = false;
    private boolean sane = false;
    MapDrawer drawer;
    int stepCount = 0;
    private final String defaultColorProvider = "org.eclipse.stem.ui.adapters.color.IntensityColorsLabelsMappingColorProvider";
    private List<DecoratorIdentifierProperty> compartmentsToLog = new ArrayList<DecoratorIdentifierProperty>();
    ColorProviderAdapter colorProviderAdapter;
    Map<Decorator, MapDrawer> mapDrawers = new HashMap<Decorator, MapDrawer>();
    File baseLogDirectory;
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());

    public DecoratorPropertyImageWriter(ISimulation simulation, ProjectedMapImageLogger logger) {
        this.logger = logger;
        this.simulation = simulation;
    }

    protected void setup() {
        this.initialized = true;
        this.setupCompartments();
        if (this.compartmentsToLog.size() == 0) {
            Activator.logError(String.valueOf(Messages.DPIW_NoCompartmentsError1) + this.logger.getURI() + Messages.DPIW_NoCompartmentsError2, null);
            return;
        }
        try {
            this.projection = this.logger.getMapProjector();
        }
        catch (Exception e) {
            Activator.logWarning(String.valueOf(Messages.DPIW_NoProjectionError1) + this.logger.getURI() + Messages.DPIW_NoProjectionError2, e);
            this.projection = new Equirectangular();
        }
        for (DecoratorIdentifierProperty compartment : this.compartmentsToLog) {
            this.configureCompartmentColorProvider(compartment);
            if (compartment.getColorProvider() == null || this.mapDrawers.get(compartment.getDecorator()) != null) continue;
            this.mapDrawers.put(compartment.getDecorator(), new MapDrawer(compartment.getDecorator(), this.logger, this.projection));
        }
        if (this.mapDrawers.size() == 0) {
            Activator.logError(String.valueOf(Messages.DPIW_NoMapDrawersError1) + this.logger.getURI() + Messages.DPIW_NoMapDrawersError2, null);
            return;
        }
        this.sane = true;
    }

    private void setupCompartments() {
        for (Decorator decorator : this.simulation.getScenario().getCanonicalGraph().getDecorators()) {
            Map identifierProperties;
            if (!(decorator instanceof IntegrationDecorator) || (identifierProperties = this.logger.getDecoratorProperties(decorator.getURI())) == null) continue;
            for (Map.Entry identifierProperty : identifierProperties.entrySet()) {
                String identifierName = (String)identifierProperty.getKey();
                for (String property : (EList)identifierProperty.getValue()) {
                    IItemPropertyDescriptor descriptor = this.getItemPropertyDescriptor((IntegrationDecorator)decorator, identifierName, property);
                    if (descriptor == null) continue;
                    this.compartmentsToLog.add(new DecoratorIdentifierProperty(decorator, identifierName, descriptor));
                }
            }
        }
    }

    private IItemPropertyDescriptor getItemPropertyDescriptor(IntegrationDecorator decorator, String populationIdentifier, String propertyName) {
        List properties = decorator.getCompartments(populationIdentifier);
        if (properties != null) {
            for (IItemPropertyDescriptor property : properties) {
                if (!propertyName.equals(property.getId(null))) continue;
                return property;
            }
        }
        return null;
    }

    private void configureCompartmentColorProvider(DecoratorIdentifierProperty compartment) {
        ColorProviderAdapter retVal = null;
        List supportedColorProviders = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProviders();
        if (supportedColorProviders.size() > 0) {
            AdapterFactory adapterFactory;
            Adapter adapter;
            Class selectedColorProvider = this.logger.getColorProvider();
            if (selectedColorProvider == null || !supportedColorProviders.contains(selectedColorProvider)) {
                for (Class clazz : supportedColorProviders) {
                    if (!clazz.getName().equals("org.eclipse.stem.ui.adapters.color.IntensityColorsLabelsMappingColorProvider")) continue;
                    selectedColorProvider = clazz;
                }
                selectedColorProvider = (Class)supportedColorProviders.get(0);
            }
            if ((adapter = (adapterFactory = ColorProviderAdapterFactory.INSTANCE.getFactoryForType(selectedColorProvider)).adapt((Notifier)compartment.getDecorator().getGraph(), (Object)selectedColorProvider)) instanceof ColorProviderAdapter) {
                retVal = (ColorProviderAdapter)adapter;
                retVal.setSelectedDecorator(compartment.getDecorator());
                retVal.setSelectedPopulationIdentifier(compartment.getIdentifier());
                if (compartment.getProperty() instanceof ItemPropertyDescriptor && retVal instanceof AbstractRelativeValueColorProviderAdapterFactory.PropertySelectionListener) {
                    ((AbstractRelativeValueColorProviderAdapterFactory.PropertySelectionListener)retVal).propertySelected((ItemPropertyDescriptor)compartment.getProperty());
                }
                compartment.setColorProvider(retVal);
            }
        }
    }

    public void start() {
    }

    public void stop() {
        for (MapDrawer drawer : this.mapDrawers.values()) {
            drawer.close();
        }
    }

    public void log() {
        if (!this.sane) {
            if (!this.initialized && this.simulation.getScenario().getSequencer().getCycle() >= 2) {
                this.setup();
            }
            return;
        }
        for (DecoratorIdentifierProperty compartment : this.compartmentsToLog) {
            MapDrawer drawer = this.mapDrawers.get(compartment.getDecorator());
            drawer.setColorProvider(compartment.getColorProvider());
            drawer.draw();
            drawer.save(this.getImageFileToLog(compartment), imageFormat);
        }
    }

    protected File getBaseLogDirectory() {
        if (this.baseLogDirectory == null) {
            StringBuilder directory = new StringBuilder();
            if (this.logger.isUseDefaultLogDirectory() || "".equals(this.logger.getDataPath())) {
                directory.append(FileUtils.getRootLoggingFolderForScenario((String)this.simulation.getScenario().getURI().toString()));
            } else {
                directory.append(this.logger.getDataPath());
            }
            directory.append(Constants.SYSTEM_PATH_SEPARATOR);
            directory.append(this.simulation.getUniqueIDString());
            directory.append(Constants.SYSTEM_PATH_SEPARATOR);
            this.baseLogDirectory = new File(directory.toString());
            this.baseLogDirectory.mkdirs();
        }
        return this.baseLogDirectory;
    }

    protected File getImageFileToLog(DecoratorIdentifierProperty compartment) {
        File baseDir = this.getBaseLogDirectory();
        String dateString = DATE_FORMATTER.format(this.simulation.getScenario().getSequencer().getCurrentTime().getTime());
        StringBuilder sb = new StringBuilder(baseDir.toString());
        sb.append(Constants.SYSTEM_PATH_SEPARATOR);
        sb.append(this.logger.getURI().lastSegment());
        sb.append(Constants.SYSTEM_PATH_SEPARATOR);
        sb.append(compartment.getDecorator().getURI().lastSegment());
        sb.append(Constants.SYSTEM_PATH_SEPARATOR);
        sb.append(compartment.getIdentifier());
        File compartmentDirectory = new File(sb.toString());
        if (!compartmentDirectory.exists()) {
            compartmentDirectory.mkdirs();
        }
        sb = new StringBuilder();
        sb.append(compartment.getProperty().getId(null));
        sb.append("_");
        sb.append(dateString);
        sb.append(".");
        sb.append(imageFormat);
        return new File(compartmentDirectory, sb.toString());
    }
}

