/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class ActiveSimulationsView
extends ViewPart {
    public static final String ID_ACTIVE_SIMULATIONS_VIEW = "org.eclipse.stem.ui.views.activesimulations";
    private ListViewer lv = null;

    public void createPartControl(Composite parent) {
        this.lv = new ListViewer(parent);
        this.lv.setContentProvider((IContentProvider)new ActiveSimulationsContentProvider());
        this.lv.setLabelProvider((IBaseLabelProvider)new ActiveSimulationsLabelProvider());
        this.lv.setInput((Object)SimulationManager.getManager());
        this.getSite().setSelectionProvider((ISelectionProvider)this.lv);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.getSite().setSelectionProvider(null);
        this.lv = null;
    }

    protected static class ActiveSimulationsContentProvider
    implements IStructuredContentProvider,
    ISimulationManagerListener {
        private ListViewer viewer = null;
        private SimulationManager simulationManager = null;

        protected ActiveSimulationsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((SimulationManager)inputElement).getActiveSimulations().toArray();
        }

        public void dispose() {
            this.viewer = null;
            this.simulationManager = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = (ListViewer)viewer;
            if (this.simulationManager != null) {
                this.simulationManager.removeListener((ISimulationManagerListener)this);
            }
            this.simulationManager = (SimulationManager)newInput;
            if (this.simulationManager != null) {
                this.simulationManager.addSimulationManagerListener((ISimulationManagerListener)this);
            }
        }

        public void simulationsChanged(SimulationManagerEvent event) {
            this.viewer.getList().setRedraw(false);
            try {
                this.viewer.remove((Object[])event.getSimulationsRemoved());
                this.viewer.add((Object[])event.getSimulationsAdded());
            }
            finally {
                this.viewer.getList().setRedraw(true);
            }
        }
    }

    protected static class ActiveSimulationsLabelProvider
    implements ILabelProvider {
        protected ActiveSimulationsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            ISimulation simulation = (ISimulation)element;
            return simulation.getNameWithSequenceNumber();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

