/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.analysis.AnalysisFactory;
import org.eclipse.stem.analysis.AnalysisPackage;
import org.eclipse.stem.analysis.CompoundErrorFunction;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.ReferenceScenarioDataMap;
import org.eclipse.stem.analysis.impl.AnalysisFactoryImpl;
import org.eclipse.stem.analysis.impl.ErrorFunctionImpl;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;

public class CompoundErrorFunctionImpl
extends ErrorFunctionImpl
implements CompoundErrorFunction {
    protected static final boolean USE_DEATHS_EDEFAULT = true;
    protected boolean useDeaths = true;
    protected static final boolean USE_CUM_SUM_EDEFAULT = true;
    protected boolean useCumSum = true;
    protected static final boolean USE_DAILY_EDEFAULT = true;
    protected boolean useDaily = true;
    Map<String, List<Double>> commonDailyIncidenceLocationsMapA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonDailyIncidenceLocationsMapB = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonCumIncidenceLocationsMapA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonCumIncidenceLocationsMapB = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonCumDeathsLocationsMapA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonCumDeathsLocationsMapB = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonPopulationLocationsA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonPopulationLocationsB = new HashMap<String, List<Double>>();
    Map<String, Double> commonAvgPopulationLocationsA = new HashMap<String, Double>();
    Map<String, Double> commonAvgPopulationLocationsB = new HashMap<String, Double>();
    Map<String, Double> commonMaxLocationsA = new HashMap<String, Double>();
    public double[] locationCount;
    public double[] meanSqDiff;
    public double[] time;
    protected AnalysisFactory aFactory = new AnalysisFactoryImpl();
    private static boolean AGGREGATE_NRMSE = true;
    private static boolean WEIGHTED_AVERAGE = true;
    private static boolean USE_THRESHOLD = false;
    private static double THRESHOLD = 0.05;
    int validationYear = -1;

    @Override
    protected EClass eStaticClass() {
        return AnalysisPackage.Literals.COMPOUND_ERROR_FUNCTION;
    }

    @Override
    public boolean isUseDeaths() {
        return this.useDeaths;
    }

    @Override
    public void setUseDeaths(boolean newUseDeaths) {
        boolean oldUseDeaths = this.useDeaths;
        this.useDeaths = newUseDeaths;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldUseDeaths, this.useDeaths));
        }
    }

    @Override
    public boolean isUseCumSum() {
        return this.useCumSum;
    }

    @Override
    public void setUseCumSum(boolean newUseCumSum) {
        boolean oldUseCumSum = this.useCumSum;
        this.useCumSum = newUseCumSum;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldUseCumSum, this.useCumSum));
        }
    }

    @Override
    public boolean isUseDaily() {
        return this.useDaily;
    }

    @Override
    public void setUseDaily(boolean newUseDaily) {
        boolean oldUseDaily = this.useDaily;
        this.useDaily = newUseDaily;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldUseDaily, this.useDaily));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.isUseDeaths();
            }
            case 3: {
                return this.isUseCumSum();
            }
            case 4: {
                return this.isUseDaily();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setUseDeaths((Boolean)newValue);
                return;
            }
            case 3: {
                this.setUseCumSum((Boolean)newValue);
                return;
            }
            case 4: {
                this.setUseDaily((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setUseDeaths(true);
                return;
            }
            case 3: {
                this.setUseCumSum(true);
                return;
            }
            case 4: {
                this.setUseDaily(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return !this.useDeaths;
            }
            case 3: {
                return !this.useCumSum;
            }
            case 4: {
                return !this.useDaily;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (useDeaths: ");
        result.append(this.useDeaths);
        result.append(", useCumSum: ");
        result.append(this.useCumSum);
        result.append(", useDaily: ");
        result.append(this.useDaily);
        result.append(')');
        return result.toString();
    }

    @Override
    public ErrorResult calculateError(ReferenceScenarioDataMap reference, ReferenceScenarioDataMap data) {
        ReferenceScenarioDataMapImpl _ref = (ReferenceScenarioDataMapImpl)reference;
        ReferenceScenarioDataMapImpl _data = (ReferenceScenarioDataMapImpl)data;
        this.time = null;
        Iterator<String> iteratorA = _ref.getLocations().iterator();
        int maxTime = -1;
        while (iteratorA.hasNext()) {
            String id = iteratorA.next();
            if (!_data.containsLocation(id)) continue;
            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapA = _ref.getLocation(id);
            List<Double> refDailyIncidenceList = null;
            refDailyIncidenceList = this.getData(this.referenceDataCompartment, dataMapA);
            List<Double> refCumDailyIncidenceList = this.getCumData(this.comparisonCompartment, dataMapA);
            List<Double> refCumDailyDeathsList = null;
            if (this.isUseDeaths()) {
                refCumDailyDeathsList = this.getDeaths(dataMapA);
            }
            List<Double> refPopulationList = this.getPopulation(dataMapA);
            this.commonDailyIncidenceLocationsMapA.put(id, refDailyIncidenceList);
            this.commonCumIncidenceLocationsMapA.put(id, refCumDailyIncidenceList);
            if (this.isUseDeaths()) {
                this.commonCumDeathsLocationsMapA.put(id, refCumDailyDeathsList);
            }
            this.commonPopulationLocationsA.put(id, refPopulationList);
            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapB = _data.getLocation(id);
            List<Double> predDailyIncidenceList = null;
            predDailyIncidenceList = this.getData(this.comparisonCompartment, dataMapB);
            List<Double> predCumDailyIncidenceList = this.getCumData(this.comparisonCompartment, dataMapB);
            List<Double> predCumDailyDeathsList = null;
            if (this.isUseDeaths()) {
                predCumDailyDeathsList = this.getDeaths(dataMapB);
            }
            List<Double> predPopulationList = this.getPopulation(dataMapB);
            this.commonDailyIncidenceLocationsMapB.put(id, predDailyIncidenceList);
            this.commonCumIncidenceLocationsMapB.put(id, predCumDailyIncidenceList);
            if (this.isUseDeaths()) {
                this.commonCumDeathsLocationsMapB.put(id, predCumDailyDeathsList);
            }
            this.commonPopulationLocationsB.put(id, predPopulationList);
            if (maxTime == -1) {
                maxTime = refDailyIncidenceList.size();
            }
            if (maxTime >= predDailyIncidenceList.size()) {
                maxTime = predDailyIncidenceList.size();
            }
            if (maxTime < refDailyIncidenceList.size()) continue;
            maxTime = refDailyIncidenceList.size();
        }
        if (maxTime <= 0) {
            maxTime = 0;
        }
        if (this.time == null) {
            this.time = new double[maxTime];
            this.meanSqDiff = new double[maxTime];
            this.locationCount = new double[maxTime];
            int i = 0;
            while (i < maxTime) {
                this.time[i] = i;
                this.meanSqDiff[i] = 0.0;
                this.locationCount[i] = 0.0;
                ++i;
            }
        }
        BasicEList errorListDailyIncidence = new BasicEList();
        BasicEList errorListCumIncidence = new BasicEList();
        BasicEList errorListCumDeaths = new BasicEList();
        double[] errorsDailyIncidence = null;
        double[] errorsCumIncidence = null;
        double[] errorsCumDeath = null;
        if (this.isUseDaily()) {
            errorsDailyIncidence = this.getSpecificErrors(this.commonDailyIncidenceLocationsMapA, this.commonDailyIncidenceLocationsMapB, (BasicEList<Double>)errorListDailyIncidence);
        }
        if (this.isUseCumSum()) {
            errorsCumIncidence = this.getSpecificErrors(this.commonCumIncidenceLocationsMapA, this.commonCumIncidenceLocationsMapB, (BasicEList<Double>)errorListCumIncidence);
        }
        if (this.isUseDeaths()) {
            errorsCumDeath = this.getSpecificErrors(this.commonCumDeathsLocationsMapA, this.commonCumDeathsLocationsMapB, (BasicEList<Double>)errorListCumDeaths);
        }
        BasicEList<Double> list = this.takeAverage((BasicEList<Double>)errorListDailyIncidence, (BasicEList<Double>)errorListCumIncidence, (BasicEList<Double>)errorListCumDeaths);
        double dailyIncidenceFinalError = 0.0;
        double cumIncidenceFinalError = 0.0;
        double cumDeathFinalError = 0.0;
        double dailyIncidenceVError = 0.0;
        double cumIncidenceVError = 0.0;
        double cumDeathVError = 0.0;
        if (errorsDailyIncidence != null) {
            dailyIncidenceFinalError = errorsDailyIncidence[0];
            dailyIncidenceVError = errorsDailyIncidence[1];
        }
        if (errorsCumIncidence != null) {
            cumIncidenceFinalError = errorsCumIncidence[0];
            cumIncidenceVError = errorsCumIncidence[1];
        }
        if (errorsCumDeath != null) {
            cumDeathFinalError = errorsCumDeath[0];
            cumDeathVError = errorsCumDeath[1];
        }
        double finalerror = this.takeAverage(dailyIncidenceFinalError, cumIncidenceFinalError, cumDeathFinalError);
        double verror = this.takeAverage(dailyIncidenceVError, cumIncidenceVError, cumDeathVError);
        ErrorResult resultobj = this.aFactory.createErrorResult();
        resultobj.setErrorByTimeStep((EList<Double>)list);
        resultobj.setError(finalerror);
        resultobj.setValidationError(verror);
        BasicEList refByTime = new BasicEList();
        BasicEList dataByTime = new BasicEList();
        int icount = 0;
        while (icount < this.time.length) {
            refByTime.add((Object)0.0);
            dataByTime.add((Object)0.0);
            ++icount;
        }
        for (String loc : this.commonDailyIncidenceLocationsMapA.keySet()) {
            int icount2 = 0;
            while (icount2 < this.time.length) {
                List<Double> dataAI = this.commonDailyIncidenceLocationsMapA.get(loc);
                List<Double> dataBI = this.commonDailyIncidenceLocationsMapB.get(loc);
                double iA = dataAI.get(icount2);
                double iB = dataBI.get(icount2);
                refByTime.set(icount2, (Object)((Double)refByTime.get(icount2) + iA));
                dataByTime.set(icount2, (Object)((Double)dataByTime.get(icount2) + iB));
                ++icount2;
            }
        }
        resultobj.setReferenceByTime((EList<Double>)refByTime);
        resultobj.setModelByTime((EList<Double>)dataByTime);
        return resultobj;
    }

    private double takeAverage(double error1, double error2, double error3) {
        int counter = 0;
        if (this.isUseCumSum()) {
            ++counter;
        }
        if (this.isUseDaily()) {
            ++counter;
        }
        if (this.isUseDeaths()) {
            ++counter;
        }
        return (error1 + error2 + error3) / (double)counter;
    }

    private BasicEList<Double> takeAverage(BasicEList<Double> errorListDailyIncidence, BasicEList<Double> errorListCumIncidence, BasicEList<Double> errorListCumDeaths) {
        int counter = 0;
        int dailyIncidenceSize = -1;
        int cumIncidenceSize = -1;
        int cumDeathsSize = -1;
        int totalSize = -1;
        if (this.isUseCumSum()) {
            ++counter;
            cumIncidenceSize = errorListCumIncidence.size();
        }
        if (this.isUseDaily()) {
            ++counter;
            dailyIncidenceSize = errorListDailyIncidence.size();
        }
        if (this.isUseDeaths()) {
            ++counter;
            cumDeathsSize = errorListCumDeaths.size();
        }
        if (dailyIncidenceSize != -1) {
            totalSize = dailyIncidenceSize;
        }
        if (cumIncidenceSize != -1 && totalSize == -1) {
            totalSize = cumIncidenceSize;
        }
        if (cumDeathsSize != -1 && totalSize == -1) {
            totalSize = cumDeathsSize;
        }
        BasicEList<Double> avgList = new BasicEList<Double>(Collections.nCopies(totalSize, 0.0));
        if (this.isUseCumSum()) {
            avgList = this.sumTwoLists(avgList, errorListCumIncidence);
        }
        if (this.isUseDaily()) {
            avgList = this.sumTwoLists(avgList, errorListDailyIncidence);
        }
        if (this.isUseDeaths()) {
            avgList = this.sumTwoLists(avgList, errorListCumDeaths);
        }
        int i = 0;
        while (i < totalSize) {
            avgList.set(i, (Object)((Double)avgList.get(i) / (double)counter));
            ++i;
        }
        return avgList;
    }

    private BasicEList<Double> sumTwoLists(BasicEList<Double> avgList, BasicEList<Double> errorList) {
        int i = 0;
        while (i < avgList.size()) {
            avgList.set(i, (Object)((Double)avgList.get(i) + (Double)errorList.get(i)));
            ++i;
        }
        return avgList;
    }

    public double[] getSpecificErrors(Map<String, List<Double>> commonDailyIncidenceLocationsMapA, Map<String, List<Double>> commonDailyIncidenceLocationsMapB, BasicEList<Double> list) {
        double sum;
        List<Double> ld;
        double[] errors = new double[2];
        double[] Xref = new double[this.time.length];
        double[] Xdata = new double[this.time.length];
        double finalerror = 0.0;
        double verror = 0.0;
        int i = 0;
        while (i < this.time.length) {
            list.add((Object)0.0);
            ++i;
        }
        for (String loc : this.commonPopulationLocationsA.keySet()) {
            ld = this.commonPopulationLocationsA.get(loc);
            sum = 0.0;
            for (double d : ld) {
                sum += d;
            }
            this.commonAvgPopulationLocationsA.put(loc, sum /= (double)ld.size());
        }
        for (String loc : this.commonPopulationLocationsB.keySet()) {
            ld = this.commonPopulationLocationsB.get(loc);
            sum = 0.0;
            for (double d : ld) {
                sum += d;
            }
            this.commonAvgPopulationLocationsB.put(loc, sum /= (double)ld.size());
        }
        for (String loc : this.commonPopulationLocationsA.keySet()) {
            ld = commonDailyIncidenceLocationsMapA.get(loc);
            double max = Double.MIN_VALUE;
            for (double d : ld) {
                if (!(d > max)) continue;
                max = d;
            }
            this.commonMaxLocationsA.put(loc, max);
        }
        double weighted_denom = 0.0;
        if (!AGGREGATE_NRMSE) {
            for (String loc : commonDailyIncidenceLocationsMapA.keySet()) {
                double maxRef = 0.0;
                double minRef = Double.MAX_VALUE;
                int icount = 0;
                while (icount < this.time.length) {
                    List<Double> dataAI = commonDailyIncidenceLocationsMapA.get(loc);
                    List<Double> dataBI = commonDailyIncidenceLocationsMapB.get(loc);
                    double iA = dataAI.get(icount);
                    double iB = dataBI.get(icount);
                    Xref[icount] = iA;
                    Xdata[icount] = iB;
                    ++icount;
                }
                double nominator = 0.0;
                double timesteps = 0.0;
                int icount2 = 0;
                while (icount2 < this.time.length) {
                    if (Xref[icount2] > maxRef) {
                        maxRef = Xref[icount2];
                    }
                    if (Xref[icount2] < minRef) {
                        minRef = Xref[icount2];
                    }
                    if (!(USE_THRESHOLD && Xref[icount2] <= THRESHOLD * this.commonMaxLocationsA.get(loc) && Xdata[icount2] <= THRESHOLD * this.commonMaxLocationsA.get(loc))) {
                        nominator += Math.pow(Xref[icount2] - Xdata[icount2], 2.0);
                        list.set(icount2, (Object)((Double)list.get(icount2) + Math.abs(Xref[icount2] - Xdata[icount2])));
                        timesteps += 1.0;
                    }
                    ++icount2;
                }
                double error = Double.MAX_VALUE;
                BigDecimal maxRefBD = new BigDecimal(maxRef);
                BigDecimal minRefBD = new BigDecimal(minRef);
                if (!(timesteps > 0.0)) continue;
                error = Math.sqrt(nominator / timesteps);
                if (maxRefBD.subtract(minRefBD).doubleValue() > 0.0) {
                    error /= maxRef - minRef;
                }
                finalerror = WEIGHTED_AVERAGE ? (finalerror += this.commonAvgPopulationLocationsA.get(loc) * error) : (finalerror += error);
                if (WEIGHTED_AVERAGE) {
                    weighted_denom += this.commonAvgPopulationLocationsA.get(loc).doubleValue();
                    continue;
                }
                weighted_denom += 1.0;
            }
            finalerror /= weighted_denom;
        } else {
            int icount = 0;
            while (icount < this.time.length) {
                for (String loc : commonDailyIncidenceLocationsMapA.keySet()) {
                    List<Double> dataAI = commonDailyIncidenceLocationsMapA.get(loc);
                    List<Double> dataBI = commonDailyIncidenceLocationsMapB.get(loc);
                    double iA = dataAI.get(icount);
                    double iB = dataBI.get(icount);
                    int n = icount;
                    Xref[n] = Xref[n] + iA;
                    int n2 = icount;
                    Xdata[n2] = Xdata[n2] + iB;
                }
                ++icount;
            }
            double maxRef = Double.MIN_VALUE;
            double minRef = Double.MAX_VALUE;
            double maxValidationRef = Double.MIN_VALUE;
            double minValidationRef = Double.MAX_VALUE;
            int icount3 = 0;
            while (icount3 < this.time.length) {
                if ((double)icount3 >= (double)this.validationYear * 365.25 && (double)icount3 <= (double)(this.validationYear + 1) * 365.25) {
                    if (Xref[icount3] > maxValidationRef) {
                        maxValidationRef = Xref[icount3];
                    }
                    if (Xref[icount3] < minValidationRef) {
                        minValidationRef = Xref[icount3];
                    }
                } else {
                    if (Xref[icount3] > maxRef) {
                        maxRef = Xref[icount3];
                    }
                    if (Xref[icount3] < minRef) {
                        minRef = Xref[icount3];
                    }
                }
                ++icount3;
            }
            double nominator = 0.0;
            double vnominator = 0.0;
            double timesteps = 0.0;
            double vtimesteps = 0.0;
            int icount4 = 0;
            while (icount4 < this.time.length) {
                if ((double)icount4 >= (double)this.validationYear * 365.25 && (double)icount4 <= (double)(this.validationYear + 1) * 365.25) {
                    if (!(USE_THRESHOLD && Xref[icount4] <= THRESHOLD * maxValidationRef && Xdata[icount4] <= THRESHOLD * maxValidationRef)) {
                        vnominator += Math.pow(Xref[icount4] - Xdata[icount4], 2.0);
                        list.set(icount4, (Object)0.0);
                        vtimesteps += 1.0;
                    }
                } else if (!(USE_THRESHOLD && Xref[icount4] <= THRESHOLD * maxRef && Xdata[icount4] <= THRESHOLD * maxRef)) {
                    nominator += Math.pow(Xref[icount4] - Xdata[icount4], 2.0);
                    list.set(icount4, (Object)Math.abs(Xref[icount4] - Xdata[icount4]));
                    timesteps += 1.0;
                }
                ++icount4;
            }
            BigDecimal maxRefBD = new BigDecimal(maxRef).setScale(5, RoundingMode.DOWN);
            BigDecimal minRefBD = new BigDecimal(minRef).setScale(5, RoundingMode.DOWN);
            BigDecimal maxValidationRefBD = new BigDecimal(maxValidationRef).setScale(5, RoundingMode.DOWN);
            BigDecimal minValidationRefBD = new BigDecimal(minValidationRef).setScale(5, RoundingMode.DOWN);
            double error = Double.MAX_VALUE;
            if (timesteps > 0.0) {
                error = Math.sqrt(nominator / timesteps);
                if (maxRefBD.subtract(minRefBD).doubleValue() > 0.0) {
                    finalerror = error / (maxRef - minRef);
                } else if (maxRefBD.subtract(minRefBD).doubleValue() == 0.0) {
                    finalerror = error;
                }
            }
            error = Double.MAX_VALUE;
            if (vtimesteps > 0.0) {
                error = Math.sqrt(vnominator / vtimesteps);
                if (maxValidationRefBD.subtract(minValidationRefBD).doubleValue() > 0.0) {
                    verror = error / (maxValidationRef - minValidationRef);
                } else if (maxValidationRefBD.subtract(minValidationRefBD).doubleValue() == 0.0) {
                    verror = error;
                }
            }
        }
        errors[0] = finalerror;
        errors[1] = verror;
        return errors;
    }
}

