/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.internal.databinding.swt.SWTVetoableValueDecorator;
import org.eclipse.jface.internal.databinding.swt.WidgetStringValueProperty;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Widget;

public class StyledTextTextProperty
extends WidgetStringValueProperty {
    public StyledTextTextProperty() {
        this(null);
    }

    public StyledTextTextProperty(int[] events) {
        super(StyledTextTextProperty.checkEvents(events), StyledTextTextProperty.staleEvents(events));
    }

    private static int[] checkEvents(int[] events) {
        if (events != null) {
            int[] nArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                int event = nArray[n2];
                StyledTextTextProperty.checkEvent(event);
                ++n2;
            }
        }
        return events;
    }

    private static void checkEvent(int event) {
        if (event != 0 && event != 24 && event != 16 && event != 14) {
            throw new IllegalArgumentException("UpdateEventType [" + event + "] is not supported.");
        }
    }

    private static int[] staleEvents(int[] changeEvents) {
        if (changeEvents != null) {
            int[] nArray = changeEvents;
            int n = changeEvents.length;
            int n2 = 0;
            while (n2 < n) {
                int changeEvent = nArray[n2];
                if (changeEvent == 24) {
                    return null;
                }
                ++n2;
            }
        }
        return new int[]{24};
    }

    @Override
    String doGetStringValue(Object source) {
        return ((StyledText)source).getText();
    }

    @Override
    void doSetStringValue(Object source, String value) {
        ((StyledText)source).setText(value == null ? "" : value);
    }

    public String toString() {
        return "StyledText.text <String>";
    }

    @Override
    protected ISWTObservableValue wrapObservable(IObservableValue observable, Widget widget) {
        return new SWTVetoableValueDecorator(widget, this, observable);
    }
}

