/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.polioopvipv.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.math.BinomialDistributionUtil;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.polioopvipv.PolioOpvIpvDiseaseModel;
import org.eclipse.stem.diseasemodels.polioopvipv.PolioOpvIpvFactory;
import org.eclipse.stem.diseasemodels.polioopvipv.PolioOpvIpvLabel;
import org.eclipse.stem.diseasemodels.polioopvipv.PolioOpvIpvLabelValue;
import org.eclipse.stem.diseasemodels.polioopvipv.PolioOpvIpvPackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRImpl;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.interventions.StandardInterventionLabelValue;

public class PolioOpvIpvDiseaseModelImpl
extends SEIRImpl
implements PolioOpvIpvDiseaseModel {
    protected static final double OPV_EFFICACY_EDEFAULT = 0.9;
    protected double opvEfficacy = 0.9;
    protected static final double REVERSION_RATE_OPV_EDEFAULT = 0.001;
    protected double reversionRateOPV = 0.001;
    protected static final double BIRTH_DEATH_RATE_DEVELOPING_EDEFAULT = 0.04;
    protected double birthDeathRateDeveloping = 0.04;
    protected static final double TRANSMISSION_RATE_OPV_EDEFAULT = 0.1;
    protected double transmissionRateOPV = 0.1;
    protected static final double TRANSMISSION_RATE_WILD_EDEFAULT = 0.5;
    protected double transmissionRateWild = 0.5;
    protected static final double RELATIVE_SUSCEPTIBILITY_RECENT_OPV_EDEFAULT = 0.25;
    protected double relativeSusceptibilityRecentOPV = 0.25;
    protected static final double RELATIVE_SUSCEPTIBILITY_IPV_EDEFAULT = 0.95;
    protected double relativeSusceptibilityIPV = 0.95;
    protected static final double INCUBATION_RATE_VACCINE_EDEFAULT = 0.1;
    protected double incubationRateVaccine = 0.1;
    protected static final double INCUBATION_RATE_WILD_EDEFAULT = 0.5;
    protected double incubationRateWild = 0.5;
    protected static final double RECOVERY_RATE_VACCINE_EDEFAULT = 0.143;
    protected double recoveryRateVaccine = 0.143;
    protected static final double RECOVERY_RATE_WILD_EDEFAULT = 0.625;
    protected double recoveryRateWild = 0.625;
    protected static final double PARALYTIC_INCIDENCE_FROM_VACCINE_EDEFAULT = 7.14E-7;
    protected double paralyticIncidenceFromVaccine = 7.14E-7;
    protected static final double PARALYTIC_CASE_PROPORTION_EDEFAULT = 0.005;
    protected double paralyticCaseProportion = 0.005;

    protected EClass eStaticClass() {
        return PolioOpvIpvPackage.Literals.POLIO_OPV_IPV_DISEASE_MODEL;
    }

    @Override
    public double getOpvEfficacy() {
        return this.opvEfficacy;
    }

    @Override
    public void setOpvEfficacy(double newOpvEfficacy) {
        this.opvEfficacy = newOpvEfficacy;
    }

    @Override
    public double getReversionRateOPV() {
        return this.reversionRateOPV;
    }

    @Override
    public void setReversionRateOPV(double newReversionRateOPV) {
        this.reversionRateOPV = newReversionRateOPV;
    }

    @Override
    public double getBirthDeathRateDeveloping() {
        return this.birthDeathRateDeveloping;
    }

    @Override
    public void setBirthDeathRateDeveloping(double newBirthDeathRateDeveloping) {
        this.birthDeathRateDeveloping = newBirthDeathRateDeveloping;
    }

    @Override
    public double getTransmissionRateOPV() {
        return this.transmissionRateOPV;
    }

    @Override
    public void setTransmissionRateOPV(double newTransmissionRateOPV) {
        this.transmissionRateOPV = newTransmissionRateOPV;
    }

    @Override
    public double getTransmissionRateWild() {
        return this.transmissionRateWild;
    }

    @Override
    public void setTransmissionRateWild(double newTransmissionRateWild) {
        this.transmissionRateWild = newTransmissionRateWild;
    }

    @Override
    public double getRelativeSusceptibilityRecentOPV() {
        return this.relativeSusceptibilityRecentOPV;
    }

    @Override
    public void setRelativeSusceptibilityRecentOPV(double newRelativeSusceptibilityRecentOPV) {
        this.relativeSusceptibilityRecentOPV = newRelativeSusceptibilityRecentOPV;
    }

    @Override
    public double getRelativeSusceptibilityIPV() {
        return this.relativeSusceptibilityIPV;
    }

    @Override
    public void setRelativeSusceptibilityIPV(double newRelativeSusceptibilityIPV) {
        this.relativeSusceptibilityIPV = newRelativeSusceptibilityIPV;
    }

    @Override
    public double getIncubationRateVaccine() {
        return this.incubationRateVaccine;
    }

    @Override
    public void setIncubationRateVaccine(double newIncubationRateVaccine) {
        this.incubationRateVaccine = newIncubationRateVaccine;
    }

    @Override
    public double getIncubationRateWild() {
        return this.incubationRateWild;
    }

    @Override
    public void setIncubationRateWild(double newIncubationRateWild) {
        this.incubationRateWild = newIncubationRateWild;
    }

    @Override
    public double getRecoveryRateVaccine() {
        return this.recoveryRateVaccine;
    }

    @Override
    public void setRecoveryRateVaccine(double newRecoveryRateVaccine) {
        this.recoveryRateVaccine = newRecoveryRateVaccine;
    }

    @Override
    public double getRecoveryRateWild() {
        return this.recoveryRateWild;
    }

    @Override
    public void setRecoveryRateWild(double newRecoveryRateWild) {
        this.recoveryRateWild = newRecoveryRateWild;
    }

    @Override
    public double getParalyticIncidenceFromVaccine() {
        return this.paralyticIncidenceFromVaccine;
    }

    @Override
    public void setParalyticIncidenceFromVaccine(double newParalyticIncidenceFromVaccine) {
        this.paralyticIncidenceFromVaccine = newParalyticIncidenceFromVaccine;
    }

    @Override
    public double getParalyticCaseProportion() {
        return this.paralyticCaseProportion;
    }

    @Override
    public void setParalyticCaseProportion(double newParalyticCaseProportion) {
        this.paralyticCaseProportion = newParalyticCaseProportion;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 25: {
                return this.getOpvEfficacy();
            }
            case 26: {
                return this.getReversionRateOPV();
            }
            case 27: {
                return this.getBirthDeathRateDeveloping();
            }
            case 28: {
                return this.getTransmissionRateOPV();
            }
            case 29: {
                return this.getTransmissionRateWild();
            }
            case 30: {
                return this.getRelativeSusceptibilityRecentOPV();
            }
            case 31: {
                return this.getRelativeSusceptibilityIPV();
            }
            case 32: {
                return this.getIncubationRateVaccine();
            }
            case 33: {
                return this.getIncubationRateWild();
            }
            case 34: {
                return this.getRecoveryRateVaccine();
            }
            case 35: {
                return this.getRecoveryRateWild();
            }
            case 36: {
                return this.getParalyticIncidenceFromVaccine();
            }
            case 37: {
                return this.getParalyticCaseProportion();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 25: {
                this.setOpvEfficacy((Double)newValue);
                return;
            }
            case 26: {
                this.setReversionRateOPV((Double)newValue);
                return;
            }
            case 27: {
                this.setBirthDeathRateDeveloping((Double)newValue);
                return;
            }
            case 28: {
                this.setTransmissionRateOPV((Double)newValue);
                return;
            }
            case 29: {
                this.setTransmissionRateWild((Double)newValue);
                return;
            }
            case 30: {
                this.setRelativeSusceptibilityRecentOPV((Double)newValue);
                return;
            }
            case 31: {
                this.setRelativeSusceptibilityIPV((Double)newValue);
                return;
            }
            case 32: {
                this.setIncubationRateVaccine((Double)newValue);
                return;
            }
            case 33: {
                this.setIncubationRateWild((Double)newValue);
                return;
            }
            case 34: {
                this.setRecoveryRateVaccine((Double)newValue);
                return;
            }
            case 35: {
                this.setRecoveryRateWild((Double)newValue);
                return;
            }
            case 36: {
                this.setParalyticIncidenceFromVaccine((Double)newValue);
                return;
            }
            case 37: {
                this.setParalyticCaseProportion((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 25: {
                this.setOpvEfficacy(0.9);
                return;
            }
            case 26: {
                this.setReversionRateOPV(0.001);
                return;
            }
            case 27: {
                this.setBirthDeathRateDeveloping(0.04);
                return;
            }
            case 28: {
                this.setTransmissionRateOPV(0.1);
                return;
            }
            case 29: {
                this.setTransmissionRateWild(0.5);
                return;
            }
            case 30: {
                this.setRelativeSusceptibilityRecentOPV(0.25);
                return;
            }
            case 31: {
                this.setRelativeSusceptibilityIPV(0.95);
                return;
            }
            case 32: {
                this.setIncubationRateVaccine(0.1);
                return;
            }
            case 33: {
                this.setIncubationRateWild(0.5);
                return;
            }
            case 34: {
                this.setRecoveryRateVaccine(0.143);
                return;
            }
            case 35: {
                this.setRecoveryRateWild(0.625);
                return;
            }
            case 36: {
                this.setParalyticIncidenceFromVaccine(7.14E-7);
                return;
            }
            case 37: {
                this.setParalyticCaseProportion(0.005);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 25: {
                return this.opvEfficacy != 0.9;
            }
            case 26: {
                return this.reversionRateOPV != 0.001;
            }
            case 27: {
                return this.birthDeathRateDeveloping != 0.04;
            }
            case 28: {
                return this.transmissionRateOPV != 0.1;
            }
            case 29: {
                return this.transmissionRateWild != 0.5;
            }
            case 30: {
                return this.relativeSusceptibilityRecentOPV != 0.25;
            }
            case 31: {
                return this.relativeSusceptibilityIPV != 0.95;
            }
            case 32: {
                return this.incubationRateVaccine != 0.1;
            }
            case 33: {
                return this.incubationRateWild != 0.5;
            }
            case 34: {
                return this.recoveryRateVaccine != 0.143;
            }
            case 35: {
                return this.recoveryRateWild != 0.625;
            }
            case 36: {
                return this.paralyticIncidenceFromVaccine != 7.14E-7;
            }
            case 37: {
                return this.paralyticCaseProportion != 0.005;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (opvEfficacy: ");
        result.append(this.opvEfficacy);
        result.append(", reversionRateOPV: ");
        result.append(this.reversionRateOPV);
        result.append(", birthDeathRateDeveloping: ");
        result.append(this.birthDeathRateDeveloping);
        result.append(", transmissionRateOPV: ");
        result.append(this.transmissionRateOPV);
        result.append(", transmissionRateWild: ");
        result.append(this.transmissionRateWild);
        result.append(", relativeSusceptibilityRecentOPV: ");
        result.append(this.relativeSusceptibilityRecentOPV);
        result.append(", relativeSusceptibilityIPV: ");
        result.append(this.relativeSusceptibilityIPV);
        result.append(", incubationRateVaccine: ");
        result.append(this.incubationRateVaccine);
        result.append(", incubationRateWild: ");
        result.append(this.incubationRateWild);
        result.append(", recoveryRateVaccine: ");
        result.append(this.recoveryRateVaccine);
        result.append(", recoveryRateWild: ");
        result.append(this.recoveryRateWild);
        result.append(", paralyticIncidenceFromVaccine: ");
        result.append(this.paralyticIncidenceFromVaccine);
        result.append(", paralyticCaseProportion: ");
        result.append(this.paralyticCaseProportion);
        result.append(')');
        return result.toString();
    }

    public void applyExternalDeltas(STEMTime currentTime, double continuousTime, long timeDelta, EList<DynamicLabel> labels) {
        super.applyExternalDeltas(currentTime, continuousTime, timeDelta, labels);
    }

    public void doStochasticProcess(IntegrationLabel iLabel, long timeDelta) {
        IntegrationLabelValue nextVal = (IntegrationLabelValue)iLabel.getNextValue();
        EList attrs = nextVal.eClass().getEAllAttributes();
        int i = 0;
        while (i < attrs.size()) {
            EAttribute attr = (EAttribute)attrs.get(i);
            if (attr.getEType().getClassifierID() == 31 && attr.isChangeable()) {
                nextVal.eSetDouble(attr.getFeatureID(), (double)Math.round(nextVal.eGetDouble(attr.getFeatureID())));
            }
            ++i;
        }
        if (this.getBinomialDistribution() == null) {
            this.setBinomialDistribution(new BinomialDistributionUtil(this.getRandomSeed()));
        }
        PolioOpvIpvLabelValue previousPolio = (PolioOpvIpvLabelValue)iLabel.getCurrentValue();
        double popCount = previousPolio.getPopulationCount();
        double adjustReversionRate = this.getReversionRateOPV() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustTransmissionRateOPV = this.getTransmissionRateOPV() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustTransmissionRateWild = this.getTransmissionRateWild() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustRelativeSusceptibilityRecentOPV = this.getRelativeSusceptibilityRecentOPV() * (double)timeDelta / (double)this.getTimePeriod();
        double r1 = (1.0 - adjustReversionRate) * adjustTransmissionRateOPV * adjustRelativeSusceptibilityRecentOPV * previousPolio.getSopv() * (previousPolio.getVopv() + previousPolio.getCipv_opv()) / popCount;
        double r2 = adjustRelativeSusceptibilityRecentOPV * previousPolio.getSopv() * adjustTransmissionRateWild * (previousPolio.getI() + previousPolio.getCipv_w()) / popCount + adjustRelativeSusceptibilityRecentOPV * previousPolio.getSopv() * adjustTransmissionRateOPV * adjustReversionRate * (previousPolio.getVopv() + previousPolio.getCipv_opv()) / popCount;
        double r3 = (1.0 - adjustReversionRate) * adjustTransmissionRateOPV * previousPolio.getS() * (previousPolio.getVopv() + previousPolio.getCipv_opv()) / popCount;
        double r4 = previousPolio.getS() * adjustTransmissionRateWild * (previousPolio.getI() + previousPolio.getCipv_w()) / popCount + previousPolio.getS() * adjustTransmissionRateOPV * adjustReversionRate * (previousPolio.getVopv() + previousPolio.getCipv_opv()) / popCount;
        double deltaIncident = r2 + r4;
        double deltaIncident_OPV = r1 + r3;
        PolioOpvIpvLabelValue next = (PolioOpvIpvLabelValue)iLabel.getNextValue();
        PolioOpvIpvLabelValue previous = (PolioOpvIpvLabelValue)iLabel.getCurrentValue();
        this.addNoise((IntegrationLabelValue)previous, (IntegrationLabelValue)next, PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Sopv(), PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Incidence_opv(), PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Eopv(), r1 / deltaIncident_OPV);
        this.addNoise((IntegrationLabelValue)previous, (IntegrationLabelValue)next, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Incidence_opv(), PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Eopv(), r3 / deltaIncident_OPV);
        this.addNoise((IntegrationLabelValue)previous, (IntegrationLabelValue)next, PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Sopv(), StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence(), StandardPackage.eINSTANCE.getSEIRLabelValue_E(), r2 / deltaIncident);
        this.addNoise((IntegrationLabelValue)previous, (IntegrationLabelValue)next, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence(), StandardPackage.eINSTANCE.getSEIRLabelValue_E(), r4 / deltaIncident);
        this.addNoise((IntegrationLabelValue)previous, (IntegrationLabelValue)next, PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Sipv(), PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Incidence_ipv_w(), PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Eipv_w(), 1.0);
        this.addNoise((IntegrationLabelValue)previous, (IntegrationLabelValue)next, PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Sipv(), PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Incidence_ipv_opv(), PolioOpvIpvPackage.eINSTANCE.getPolioOpvIpvLabelValue_Eipv_opv(), 1.0);
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustOPVEfficacy = this.getOpvEfficacy() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustReversionRate = this.getReversionRateOPV() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustTransmissionRateOPV = this.getTransmissionRateOPV() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustTransmissionRateWild = this.getTransmissionRateWild() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustRelativeSusceptibilityRecentOPV = this.getRelativeSusceptibilityRecentOPV() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustRelativeSusceptibilityIPV = this.getRelativeSusceptibilityIPV() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustIncubationRateVaccine = this.getIncubationRateVaccine() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustIncubationRateWild = this.getIncubationRateWild() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustRecoveryRateVaccine = this.getRecoveryRateVaccine() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustRecoveryRateWild = this.getRecoveryRateWild() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustParalyticIncidenceFromVaccine = this.getParalyticIncidenceFromVaccine() * (double)timeDelta / (double)this.getTimePeriod();
        double adjustParalyticIncidenceFromWildPolio = this.getParalyticCaseProportion() * (double)timeDelta / (double)this.getTimePeriod();
        int _i = 0;
        while (_i < labels.size()) {
            PolioOpvIpvLabel diseaseLabel = (PolioOpvIpvLabel)labels.get(_i);
            PolioOpvIpvLabelValue currentDiseaseState = (PolioOpvIpvLabelValue)diseaseLabel.getProbeValue();
            PolioOpvIpvLabelValue deltaValue = (PolioOpvIpvLabelValue)diseaseLabel.getDeltaValue();
            deltaValue.reset();
            double popCount = currentDiseaseState.getPopulationCount();
            double effectiveInfectiousI = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentDiseaseState.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double effectiveInfectiousVopv = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentDiseaseState.getVopv(), PolioOpvIpvPackage.Literals.POLIO_OPV_IPV_LABEL_VALUE__VOPV, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double effectiveInfectiousCipv_w = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentDiseaseState.getCipv_w(), PolioOpvIpvPackage.Literals.POLIO_OPV_IPV_LABEL_VALUE__CIPV_W, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double effectiveInfectiousCipv_opv = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentDiseaseState.getCipv_opv(), PolioOpvIpvPackage.Literals.POLIO_OPV_IPV_LABEL_VALUE__CIPV_OPV, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double r1 = (1.0 - adjustReversionRate) * adjustTransmissionRateOPV * adjustRelativeSusceptibilityRecentOPV * currentDiseaseState.getSopv() * (effectiveInfectiousVopv + effectiveInfectiousCipv_opv);
            double r2 = adjustRelativeSusceptibilityRecentOPV * currentDiseaseState.getSopv() * adjustTransmissionRateWild * (effectiveInfectiousI + effectiveInfectiousCipv_w) + adjustRelativeSusceptibilityRecentOPV * currentDiseaseState.getSopv() * adjustTransmissionRateOPV * adjustReversionRate * (effectiveInfectiousVopv + effectiveInfectiousCipv_opv);
            double r3 = (1.0 - adjustReversionRate) * adjustTransmissionRateOPV * currentDiseaseState.getS() * (effectiveInfectiousVopv + effectiveInfectiousCipv_opv);
            double r4 = currentDiseaseState.getS() * adjustTransmissionRateWild * (effectiveInfectiousI + effectiveInfectiousCipv_w) + currentDiseaseState.getS() * adjustTransmissionRateOPV * adjustReversionRate * (effectiveInfectiousVopv + effectiveInfectiousCipv_opv);
            double r5 = adjustRelativeSusceptibilityIPV * currentDiseaseState.getSipv() * adjustTransmissionRateWild * (effectiveInfectiousI + effectiveInfectiousCipv_w) + adjustRelativeSusceptibilityIPV * currentDiseaseState.getSipv() * adjustTransmissionRateOPV * adjustReversionRate * (effectiveInfectiousVopv + effectiveInfectiousCipv_opv);
            double r6 = (1.0 - adjustReversionRate) * adjustTransmissionRateOPV * adjustRelativeSusceptibilityIPV * currentDiseaseState.getSipv() * (effectiveInfectiousVopv + effectiveInfectiousCipv_opv);
            double r7 = (1.0 - adjustOPVEfficacy) * adjustRecoveryRateVaccine * currentDiseaseState.getVopv();
            double r8 = adjustIncubationRateVaccine * currentDiseaseState.getEopv();
            double r9 = adjustIncubationRateWild * currentDiseaseState.getE();
            double r10 = adjustIncubationRateWild * currentDiseaseState.getEipv_w();
            double r11 = adjustIncubationRateVaccine * currentDiseaseState.getEipv_opv();
            double r12 = (1.0 - adjustParalyticIncidenceFromVaccine) * adjustRecoveryRateVaccine * adjustOPVEfficacy * currentDiseaseState.getVopv();
            double r13 = adjustParalyticIncidenceFromVaccine * adjustRecoveryRateVaccine * adjustOPVEfficacy * currentDiseaseState.getVopv();
            double r14 = (1.0 - adjustParalyticIncidenceFromWildPolio) * adjustRecoveryRateWild * currentDiseaseState.getI();
            double r15 = adjustParalyticIncidenceFromWildPolio * adjustRecoveryRateWild * currentDiseaseState.getI();
            double r16 = adjustRecoveryRateWild * currentDiseaseState.getCipv_w();
            double r17 = adjustRecoveryRateVaccine * currentDiseaseState.getCipv_opv();
            double deltaS = -r3 - r4;
            double deltaSopv = r7 - r1 - r2;
            double deltaSipv = -r5 - r6;
            double deltaEopv = r1 + r3 - r8;
            double deltaEw = r2 + r4 - r9;
            double deltaEipv_w = r5 - r10;
            double deltaEipv_opv = r6 - r11;
            double deltaVopv = r8 - r7 - r12 - r13;
            double deltaIw = r9 - r14 - r15;
            double deltaCipv_w = r10 - r16;
            double deltaCipv_opv = r11 - r17;
            double deltaPopv = r13;
            double deltaPw = r15;
            double deltaR = r12 + r14 + r16 + r17;
            double deltaIncident = r2 + r4;
            double deltaIncident_OPV = r1 + r3;
            double deltaIncident_IPV_W = r5;
            double deltaIncident_IPV_OPV = r6;
            StandardInterventionLabel scl = this.findInterventionLabel((Node)diseaseLabel.getIdentifiable());
            if (scl != null) {
                double availPopToBeVaccinated;
                double vaccinations = ((StandardInterventionLabelValue)scl.getCurrentValue()).getVaccinations();
                if ((vaccinations *= (double)timeDelta / (double)this.getTimePeriod()) > (availPopToBeVaccinated = popCount - currentDiseaseState.getPopv() - currentDiseaseState.getPw())) {
                    vaccinations = availPopToBeVaccinated;
                }
                double vaccineS = vaccinations * currentDiseaseState.getS() / availPopToBeVaccinated;
                double vaccineSopv = vaccinations * currentDiseaseState.getSopv() / availPopToBeVaccinated;
                double vaccineSipv = vaccinations * currentDiseaseState.getSipv() / availPopToBeVaccinated;
                deltaS -= vaccineS;
                deltaEopv += vaccineS + (deltaSopv -= vaccineSopv);
                deltaEipv_opv += (deltaSipv -= vaccineSipv);
            }
            deltaValue.setS(deltaS);
            deltaValue.setSopv(deltaSopv);
            deltaValue.setSipv(deltaSipv);
            deltaValue.setEopv(deltaEopv);
            deltaValue.setE(deltaEw);
            deltaValue.setEipv_w(deltaEipv_w);
            deltaValue.setEipv_opv(deltaEipv_opv);
            deltaValue.setVopv(deltaVopv);
            deltaValue.setI(deltaIw);
            deltaValue.setCipv_w(deltaCipv_w);
            deltaValue.setCipv_opv(deltaCipv_opv);
            deltaValue.setPopv(deltaPopv);
            deltaValue.setPw(deltaPw);
            deltaValue.setR(deltaR);
            deltaValue.setIncidence(deltaIncident);
            deltaValue.setIncidence_opv(deltaIncident_OPV);
            deltaValue.setIncidence_ipv_w(deltaIncident_IPV_W);
            deltaValue.setIncidence_ipv_opv(deltaIncident_IPV_OPV);
            this.computeAdditionalDeltasAndExchanges((IntegrationLabel)diseaseLabel, time, t, timeDelta);
            ++_i;
        }
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        PolioOpvIpvLabel label = PolioOpvIpvFactory.eINSTANCE.createPolioOpvIpvLabel();
        label.setTypeURI(DiseaseModelLabel.URI_TYPE_DYNAMIC_DISEASE_LABEL);
        return label;
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return PolioOpvIpvFactory.eINSTANCE.createPolioOpvIpvLabelValue();
    }
}

