/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseStreamMessage;

public class HTTPResponseReader
extends HTTPMessageReader {
    private static final Logger LOGGER = Logger.getLogger(HTTPResponseReader.class);
    private final int id;

    public HTTPResponseReader(int n, InputStream inputStream) {
        super(inputStream);
        this.id = n;
    }

    protected void readFirstLine(HTTPMessage hTTPMessage, long l) throws IOException, TimeoutException {
        HTTPResponseStreamMessage hTTPResponseStreamMessage = (HTTPResponseStreamMessage)hTTPMessage;
        HTTPMessageBuffer hTTPMessageBuffer = hTTPMessage.getBuffer();
        this.readNextToken(l, hTTPMessageBuffer, hTTPResponseStreamMessage.getHTTPVersion(), ' ');
        if (this.getLastByte() != 32) {
            throw new IOException("Unexpected char (expected=SP): " + Integer.toString(this.getLastByte()));
        }
        this.skipSpaces(l, hTTPMessageBuffer);
        this.readNextToken(l, hTTPMessageBuffer, hTTPResponseStreamMessage.getStatusCode(), ' ');
        if (this.getLastByte() != 32) {
            throw new IOException("Unexpected char (expected=SP): " + Integer.toString(this.getLastByte()));
        }
        this.skipSpaces(l, hTTPMessageBuffer);
        this.readNextToken(l, hTTPMessageBuffer, hTTPResponseStreamMessage.getReasonPhrase());
        if (this.getLastByte() != 10) {
            throw new IOException("Unexpected char (expected=LF): " + Integer.toString(this.getLastByte()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Response-RFL:" + hTTPResponseStreamMessage.getHTTPVersionAsString() + " " + hTTPResponseStreamMessage.getStatusCodeAsString() + " " + hTTPResponseStreamMessage.getReasonPhraseAsString());
        }
    }
}

