/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import org.eclipse.actf.visualization.gui.msaa.properties.IPropertyInvoke;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertyTreeEntry {
    private IPropertySource source;
    private IPropertyDescriptor descriptor;
    private PropertyTreeEntry parent;
    private Object id;
    private String path;
    private int color = -1;

    public PropertyTreeEntry(PropertyTreeEntry propertyTreeEntry, IPropertySource iPropertySource, IPropertyDescriptor iPropertyDescriptor) {
        this.parent = propertyTreeEntry;
        this.source = iPropertySource;
        this.descriptor = iPropertyDescriptor;
        this.id = iPropertyDescriptor.getId();
        this.path = propertyTreeEntry == null ? "" : String.valueOf(propertyTreeEntry.path) + "/";
        this.path = String.valueOf(this.path) + this.id.toString();
    }

    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    public String getValueAsString() {
        Object object = this.getValue();
        if (object == null) {
            return "null";
        }
        if (object instanceof IPropertySource) {
            object = ((IPropertySource)object).getEditableValue();
        }
        if (object == null) {
            return null;
        }
        ILabelProvider iLabelProvider = this.descriptor.getLabelProvider();
        if (iLabelProvider == null) {
            return object.toString();
        }
        String string = iLabelProvider.getText(object);
        if (string == null) {
            return "";
        }
        return string;
    }

    public Object getId() {
        return this.id;
    }

    public IPropertySource getPropertySource() {
        return this.source;
    }

    public String getPath() {
        return this.path;
    }

    public Object getValue() {
        return this.id != null ? this.source.getPropertyValue(this.id) : null;
    }

    public boolean canInvoke() {
        if (this.id != null && this.source instanceof IPropertyInvoke) {
            return ((IPropertyInvoke)this.source).canInvoke(this.id);
        }
        return false;
    }

    public PropertyTreeEntry getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public Object[] getChildren() {
        Object object = this.getValue();
        if (object instanceof IPropertySource) {
            return PropertyTreeEntry.getElements(this, (IPropertySource)object);
        }
        return new Object[0];
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public static Object[] getElements(PropertyTreeEntry propertyTreeEntry, IPropertySource iPropertySource) {
        IPropertyDescriptor[] iPropertyDescriptorArray = iPropertySource.getPropertyDescriptors();
        IPropertyDescriptor[] iPropertyDescriptorArray2 = new IPropertyDescriptor[]{};
        if (iPropertySource instanceof IPropertyInvoke) {
            iPropertyDescriptorArray2 = ((IPropertyInvoke)iPropertySource).getPropertyDescriptorsExtra();
        }
        Object[] objectArray = new Object[iPropertyDescriptorArray.length + iPropertyDescriptorArray2.length];
        int n = 0;
        while (n < iPropertyDescriptorArray.length) {
            objectArray[n] = new PropertyTreeEntry(propertyTreeEntry, iPropertySource, iPropertyDescriptorArray[n]);
            ++n;
        }
        n = 0;
        while (n < iPropertyDescriptorArray2.length) {
            objectArray[iPropertyDescriptorArray.length + n] = new PropertyTreeEntry(propertyTreeEntry, iPropertySource, iPropertyDescriptorArray2[n]);
            ++n;
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof PropertyTreeEntry) {
            return this.path.equals(((PropertyTreeEntry)object).path);
        }
        return false;
    }
}

