/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html.errorhandler;

import java.io.IOException;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.NodeUtil;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.dom.html.errorhandler.HTMLErrorHandler;
import org.eclipse.actf.model.internal.dom.html.parser.HTMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormExpander
implements IErrorHandler {
    private HTMLErrorHandler htmlErrorHandler;
    private HTMLParser parser;

    public void addTo(IHTMLParser iHTMLParser) {
        IErrorHandler[] iErrorHandlerArray = iHTMLParser.getErrorHandlers();
        int n = 0;
        while (n < iErrorHandlerArray.length) {
            if (iErrorHandlerArray[n] instanceof HTMLErrorHandler) {
                this.htmlErrorHandler = (HTMLErrorHandler)iErrorHandlerArray[n];
                this.htmlErrorHandler.setKeepForm(false);
                break;
            }
            ++n;
        }
        iHTMLParser.addErrorHandler(this);
    }

    public void remove() {
        if (this.htmlErrorHandler != null) {
            this.htmlErrorHandler.setKeepForm(true);
            this.parser.removeErrorHandler(this);
        }
    }

    public boolean handleError(int n, IParser iParser, Node node) throws ParseException, IOException, SAXException {
        String string = node.getNodeName();
        if (n == 5 && node instanceof EndTag && string.equalsIgnoreCase("FORM")) {
            NodeList nodeList = iParser.getDocument().getElementsByTagName("FORM");
            Element element = (Element)nodeList.item(nodeList.getLength() - 1);
            if (element == null || iParser.hasEndTag(element)) {
                return false;
            }
            Element element2 = element;
            Element[] elementArray = iParser.getContextElements();
            block0: while (element2.getParentNode() instanceof Element) {
                Element element3 = (Element)element2.getParentNode();
                if (element2.getElementsByTagName("FORM").getLength() > 1) break;
                int n2 = elementArray.length - 1;
                while (n2 >= 0) {
                    if (elementArray[n2] == element3) {
                        Node node2 = element2.getNextSibling();
                        while (node2 != null) {
                            if (node2 instanceof Element && ((Element)node2).getElementsByTagName("FORM").getLength() > 0) break block0;
                            node2 = node2.getNextSibling();
                        }
                        NodeUtil.remove(element);
                        NodeUtil.add(element3, element, element2, element3.getLastChild());
                        if (n2 != elementArray.length - 1) {
                            iParser.setContext(element3);
                        }
                        ((EndTag)node).setElement(element);
                        iParser.setHasEndTag(element);
                        iParser.error(n, "Expanded " + element);
                        return true;
                    }
                    --n2;
                }
                element2 = element3;
            }
        }
        return false;
    }
}

