/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.InputStream;
import java.net.Socket;
import org.eclipse.actf.util.httpproxy.core.IClientConnection;
import org.eclipse.actf.util.httpproxy.core.IHTTPMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.FixedSizeQueue;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPRequestReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseReader;
import org.eclipse.actf.util.internal.httpproxy.core.ServerConnection;
import org.eclipse.actf.util.internal.httpproxy.core.Session;

public abstract class RequestDispatcher
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(RequestDispatcher.class);
    private final int fId;
    private FixedSizeQueue fArrivedMsgs;
    private IHTTPRequestMessage fNextMsg = null;
    protected final Session fSession;

    protected RequestDispatcher(String string, Session session, IClientConnection iClientConnection, Socket socket, int n) {
        super(string);
        this.fSession = session;
        this.fId = socket.getPort();
        this.fArrivedMsgs = new FixedSizeQueue(n);
    }

    public int getDispatcherId() {
        return this.fId;
    }

    public void putRequest(IHTTPRequestMessage iHTTPRequestMessage, long l) throws InterruptedException, TimeoutException {
        this.fArrivedMsgs.put(iHTTPRequestMessage, l);
        if (LOGGER.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Request received from a client: ");
            stringBuffer.append("tid=").append(iHTTPRequestMessage.getTid());
            stringBuffer.append(", msgSerial=").append(iHTTPRequestMessage.getSerial());
            this.DEBUG(stringBuffer.toString());
        }
    }

    synchronized boolean responseArrived(ServerConnection serverConnection, IHTTPResponseMessage iHTTPResponseMessage) throws InterruptedException {
        boolean bl;
        if (LOGGER.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Response arrived from a server (").append(serverConnection);
            stringBuffer.append("): tid=").append(iHTTPResponseMessage.getTid());
            stringBuffer.append(", msgSerial=").append(iHTTPResponseMessage.getSerial());
            this.DEBUG(stringBuffer.toString());
        }
        return bl = this.fSession.receiveResponse(iHTTPResponseMessage);
    }

    private String msgToString(IHTTPMessage iHTTPMessage) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iHTTPMessage == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("(ser=").append(iHTTPMessage.getSerial());
            stringBuffer.append(",tid=").append(iHTTPMessage.getTid()).append(')');
        }
        return stringBuffer.toString();
    }

    private String dumpMessages() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Sent=").append(this.msgToString(this.fSession.getRequestMessage()));
        stringBuffer.append(", Next=").append(this.msgToString(this.fNextMsg));
        stringBuffer.append(", Arrived=").append(this.fArrivedMsgs.getSize());
        return stringBuffer.toString();
    }

    public HTTPRequestReader createHTTPRequestReader(InputStream inputStream) {
        return new HTTPRequestReader(inputStream);
    }

    public HTTPResponseReader createHTTPResponseReader(InputStream inputStream) {
        return new HTTPResponseReader(this.getDispatcherId(), inputStream);
    }

    protected IHTTPRequestMessage getNextRequest() throws InterruptedException {
        if (this.fNextMsg != null) {
            this.DEBUG("Reuse the same request");
            return this.fNextMsg;
        }
        this.fNextMsg = (IHTTPRequestMessage)this.fArrivedMsgs.remove();
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Filled a message: msgSerial=" + this.fNextMsg.getSerial() + ", tid=" + this.fNextMsg.getTid());
            this.DEBUG(this.dumpMessages());
        }
        return this.fNextMsg;
    }

    protected void clearNextRequest() {
        this.fNextMsg = null;
    }

    protected void startSessionAndSendRequest(IHTTPRequestMessage iHTTPRequestMessage, ServerConnection serverConnection, long l) throws InterruptedException, TimeoutException {
        this.fSession.start(iHTTPRequestMessage);
        serverConnection.putRequest(iHTTPRequestMessage, l);
    }

    public abstract void run();

    public void close() {
        this.DEBUG("Closing a RequestDispatcher");
        this.interrupt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RequestDispatcher-").append(this.fId);
        return stringBuffer.toString();
    }

    protected void DEBUG(String string) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.toString()).append(": ").append(string);
            LOGGER.debug(stringBuffer.toString());
        }
    }

    protected void WARNING(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString()).append(": ").append(string);
        LOGGER.warning(stringBuffer.toString());
    }

    protected void INFO(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString()).append(": ").append(string);
        LOGGER.info(stringBuffer.toString());
    }
}

