/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.errorhandler;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.html.parser.HTMLParser;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class InterleavedEndtagExchanger
implements IErrorHandler {
    public boolean handleError(int n, IParser iParser, Node node) throws ParseException, IOException, SAXException {
        if (n != 6 || !(node instanceof EndTag)) {
            return false;
        }
        Node node2 = iParser.getContext();
        while (node2 instanceof Element) {
            ElementDefinition elementDefinition;
            if (!node2.getNodeName().equalsIgnoreCase(node.getNodeName()) && !(elementDefinition = ((ISGMLParser)iParser).getDTD().getElementDefinition(node2.getNodeName())).endTagOmittable() && this.exchangeEndtag(iParser, node, elementDefinition.getName())) {
                return true;
            }
            node2 = node2.getParentNode();
        }
        return false;
    }

    private boolean exchangeEndtag(IParser iParser, Node node, String string) throws ParseException, IOException, SAXException {
        Node[] nodeArray = new Node[iParser.getPushbackBufferSize() / 2];
        int n = 0;
        while (n < iParser.getPushbackBufferSize() / 2) {
            Node node2 = iParser.getNode();
            if (node2 instanceof EndTag && node2.getNodeName().equalsIgnoreCase(string)) {
                iParser.error(6, node + " and " + node2 + " are interleaved. So exchange it by an error handler.");
                iParser.pushBackNode(node);
                while (n > 0) {
                    iParser.pushBackNode(nodeArray[--n]);
                }
                iParser.pushBackNode(node2);
                return true;
            }
            nodeArray[n] = node2;
            ++n;
        }
        while (n > 0) {
            iParser.pushBackNode(nodeArray[--n]);
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            HTMLParser hTMLParser = new HTMLParser();
            hTMLParser.addErrorLogListener(new IErrorLogListener(){

                public void errorLog(int n, String string) {
                    System.err.println(string);
                }
            });
            hTMLParser.setErrorHandler(new InterleavedEndtagExchanger());
            hTMLParser.parse(new FileInputStream(stringArray[0]));
        }
        catch (Exception exception) {}
    }
}

