/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import java.util.HashMap;
import java.util.Map;

public class TextUtil {
    private static Map<Character, String> replaceMap = new HashMap<Character, String>();

    static {
        replaceMap.put(new Character('\u2122'), "trade mark");
        replaceMap.put(new Character('\u00a9'), "copyright mark");
        replaceMap.put(new Character('\u00ae'), "registered mark");
    }

    public static StringBuffer replace(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            String string = replaceMap.get(new Character(stringBuffer.charAt(n2)));
            if (string != null) {
                stringBuffer.deleteCharAt(n2);
                stringBuffer.insert(n2, " " + string);
                n2 += string.length();
                n += string.length();
            }
            ++n2;
        }
        return stringBuffer;
    }

    public static String substitute(String string, String string2, String string3) {
        int n = string.indexOf(string2.toLowerCase());
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(string.substring(0, n)) + string3);
        if (n + string2.length() < string.length()) {
            String string4 = string.substring(n + string2.length(), string.length());
            stringBuffer.append(TextUtil.substitute(string4, string2, string3));
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String trim(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return "";
        }
        try {
            char c = string.charAt(n);
            while (true) {
                if (n >= n2 || !Character.isWhitespace(c) && !Character.isSpaceChar(c) && !TextUtil.isReturn(c)) {
                    if (n == 0 || n2 - n != 1) break;
                    return string.substring(n, n2 + 1);
                }
                if (++n == n2) {
                    return "";
                }
                c = string.charAt(n);
            }
            c = string.charAt(--n2);
            while (true) {
                if (n >= n2 || !Character.isWhitespace(c) && !Character.isSpaceChar(c) && !TextUtil.isReturn(c)) {
                    return string.substring(n, n2 + 1);
                }
                c = string.charAt(--n2);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return string;
        }
    }

    private static boolean isReturn(char c) {
        if (c == '\n') {
            return true;
        }
        return c == '\r';
    }
}

