/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli;

import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.Command;
import org.eclipse.iot.tiaki.cli.CommandFactory;
import org.eclipse.iot.tiaki.cli.common.ExitCodes;
import org.eclipse.iot.tiaki.cli.console.DefaultConsoleWriter;
import org.eclipse.iot.tiaki.cli.exception.CommandNotFoundException;
import org.eclipse.iot.tiaki.cli.exception.ExecutionException;
import org.eclipse.iot.tiaki.cli.exception.OptionsNotValidException;
import org.eclipse.iot.tiaki.cli.exception.ParsingException;
import org.eclipse.iot.tiaki.cli.parser.DefaultOptionParser;
import org.eclipse.iot.tiaki.cli.parser.Options;

public class Launcher {
    public static void main(String[] args) {
        DefaultConsoleWriter consoleWriter = new DefaultConsoleWriter();
        DefaultOptionParser parser = new DefaultOptionParser();
        try {
            OptionSet optionSet = parser.parse(args);
            Command command = CommandFactory.buildCommand(optionSet);
            command.initialize(optionSet);
            command.execute();
        }
        catch (ParsingException e) {
            consoleWriter.error("ERROR: Argument parsing error: " + e.getMessage());
            consoleWriter.error(Options.getUsage());
            System.exit(ExitCodes.INVALID_ARGS.getExitCode());
        }
        catch (CommandNotFoundException e) {
            consoleWriter.error("ERROR: Command not found");
            consoleWriter.error(Options.getUsage());
            System.exit(ExitCodes.INVALID_ARGS.getExitCode());
        }
        catch (OptionsNotValidException e) {
            consoleWriter.error("ERROR: Invalid command arguments: " + e.getMessage());
            consoleWriter.error(Options.getUsage());
            System.exit(ExitCodes.INVALID_ARGS.getExitCode());
        }
        catch (ExecutionException e) {
            consoleWriter.error("ERROR: " + e.getMessage());
            System.exit(e.getExitCode());
        }
        catch (RuntimeException e) {
            consoleWriter.error("ERROR: " + e.getMessage());
            System.exit(ExitCodes.GENERIC_ERROR.getExitCode());
        }
    }
}

