/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.command;

import java.util.Set;
import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.ConsoleWriter;
import org.eclipse.iot.tiaki.cli.command.DnsSdAbstractCommand;
import org.eclipse.iot.tiaki.cli.exception.ExecutionException;
import org.eclipse.iot.tiaki.cli.exception.OptionsNotValidException;
import org.eclipse.iot.tiaki.cli.util.DisplayUtil;
import org.eclipse.iot.tiaki.cli.util.OptionUtil;
import org.eclipse.iot.tiaki.domain.CertRecord;
import org.eclipse.iot.tiaki.domain.CompoundLabel;
import org.eclipse.iot.tiaki.domain.DnsCertPrefix;
import org.eclipse.iot.tiaki.domain.Fqdn;
import org.eclipse.iot.tiaki.exceptions.DnsServiceException;
import org.eclipse.iot.tiaki.exceptions.LookupException;

public class ListTlsaRecordsCommand
extends DnsSdAbstractCommand {
    private Fqdn domain;
    private String label;
    private DnsCertPrefix tlsaPrefix;

    @Override
    public void initialize(OptionSet optionSet) throws ExecutionException, OptionsNotValidException {
        super.initialize(optionSet);
        this.label = OptionUtil.getOptionValue(optionSet, "supplement", true);
        if (CompoundLabel.isCompound(this.label)) {
            throw new OptionsNotValidException(String.format("%s: %s", "Invalid Argument Usage", "unexpected 'Compound Label' in input"));
        }
        this.domain = new Fqdn(this.label, OptionUtil.getOptionValue(optionSet, "domain", true));
        this.tlsaPrefix = new DnsCertPrefix(OptionUtil.getOptionValue(optionSet, "tlsa", false));
    }

    @Override
    public void doExecute(ConsoleWriter consoleWriter) throws DnsServiceException {
        Set<CertRecord> records = null;
        try {
            records = this.dnsSd.listTLSARecords(this.domain, this.tlsaPrefix, !this.insecureMode);
        }
        catch (LookupException le) {
            throw new DnsServiceException(le.dnsError(), String.format(DisplayUtil.map(le.dnsError()), this.domain.fqdn()), true);
        }
        for (CertRecord record : records) {
            consoleWriter.log(record.toString());
        }
    }
}

