/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.util;

import org.eclipse.iot.tiaki.commons.StatusCode;

public class DisplayUtil {
    public static final String UNEXPECTED_ERROR = "Unexpected Error";
    public static final String INVALID_ARGUMENT = "Invalid Argument Usage";
    public static final String INVALID_DNS_HOST = "Invalid DNS Server Host";
    public static final String INTERNAL_ERROR = "Inernal Lib Error";
    public static final String UNREACHABLE_DNS = "Unreachable DNS Server or Timeout Expired";
    public static final String LOOKUP_ERROR = "Generic Lookup Error: look at the Errors Trace";
    public static final String INSECURE_DNS_RESPONSE = "Insecure DNS response";
    public static final String DNSSEC_STATUS_ERROR = "DNSSEC Status Check failed for domain";
    public static final String UNEXPECTED_RR_TYPE = "Unexpected Resource Record Type";
    public static final String DNS_FAILURE = "DNS Server Failure";
    public static final String DNS_NAME_NOT_EXIST = "DNS Name does not exist";
    public static final String RR_TYPE_NOT_EXIST = "RR Type does not exist";
    public static final String INVALID_FQDN = "Invalid Fully Qualified Domain Name";
    public static final String SECURE_DNS_RESPONSE = "DNSSEC Status Check for domain successful";

    public static String map(StatusCode status) {
        if (status == StatusCode.SERVER_ERROR) {
            return DNS_FAILURE;
        }
        if (status == StatusCode.RESOLUTION_NAME_ERROR) {
            return DNS_NAME_NOT_EXIST;
        }
        if (status == StatusCode.RESOLUTION_RR_TYPE_ERROR) {
            return RR_TYPE_NOT_EXIST;
        }
        if (status == StatusCode.RESOURCE_UNEXPECTED) {
            return UNEXPECTED_RR_TYPE;
        }
        if (status == StatusCode.SERVER_ERROR || status == StatusCode.RESOURCE_INSECURE_ERROR) {
            return INSECURE_DNS_RESPONSE;
        }
        if (status == StatusCode.DNSSEC_STATUS_ERROR) {
            return DNSSEC_STATUS_ERROR;
        }
        if (status == StatusCode.RESOURCE_LOOKUP_ERROR) {
            return LOOKUP_ERROR;
        }
        if (status == StatusCode.NETWORK_ERROR) {
            return UNREACHABLE_DNS;
        }
        if (status == StatusCode.ILLEGAL_FQDN) {
            return INVALID_FQDN;
        }
        return String.format("Unrecognized status: [%s]", status.statusLabel());
    }

    private DisplayUtil() {
        throw new AssertionError((Object)String.format("Class %s not instantiable", this.getClass().getName()));
    }
}

