/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.domain;

import java.util.Objects;
import org.eclipse.iot.tiaki.domain.DiscoveryRecord;
import org.eclipse.iot.tiaki.domain.ServiceRecord;
import org.eclipse.iot.tiaki.domain.TextRecord;

public final class ServiceInstance
extends DiscoveryRecord {
    private final String serviceType;
    private final ServiceRecord serviceRecord;
    private final TextRecord textRecord;

    public ServiceInstance(String serviceType, ServiceRecord serviceRecord, TextRecord textRecord) {
        super(String.format("%s %s %d %d %d %d %s", serviceType, serviceRecord.getHost(), serviceRecord.getPort(), serviceRecord.getPriority(), serviceRecord.getWeight(), serviceRecord.getTtl(), textRecord.getRData()), serviceRecord.getTtl());
        this.serviceType = serviceType;
        this.serviceRecord = serviceRecord;
        this.textRecord = textRecord;
    }

    public ServiceRecord getServiceRecord() {
        return this.serviceRecord;
    }

    public TextRecord getTextRecord() {
        return this.textRecord;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.serviceType, this.serviceRecord, this.textRecord);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceInstance that = (ServiceInstance)obj;
        return Objects.equals(this.serviceType, that.getServiceType()) && Objects.equals(this.serviceRecord, that.getServiceRecord()) && Objects.equals(this.textRecord, that.getTextRecord());
    }

    @Override
    public int compareTo(DiscoveryRecord other) {
        if (other instanceof ServiceInstance) {
            ServiceInstance real = (ServiceInstance)other;
            if (this.serviceRecord != null && real.serviceRecord != null) {
                return this.serviceRecord.compareTo(real.serviceRecord);
            }
        } else {
            return super.compareTo(other);
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serviceRecord);
        if (this.textRecord != null) {
            sb.append(" ").append(this.textRecord.getRData());
        }
        return sb.toString();
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public String getServiceZone(String dnsLabel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getServiceName(String dnsLabel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toDisplay() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

