/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.iot.tiaki.commons.LookupContext;
import org.eclipse.iot.tiaki.commons.StatusCode;
import org.eclipse.iot.tiaki.domain.Fqdn;
import org.eclipse.iot.tiaki.domain.TextRecord;
import org.eclipse.iot.tiaki.exceptions.ConfigurationException;
import org.eclipse.iot.tiaki.exceptions.LookupException;
import org.eclipse.iot.tiaki.utils.ExceptionsUtil;
import org.eclipse.iot.tiaki.utils.RDataUtil;
import org.jitsi.dnssec.validator.ValidatingResolver;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public final class DnsUtil {
    private static final String INSECURE = "insecure";
    private static final String CHAIN_OF_TRUST = "chain of trust";
    private static final String NO_DATA = "nodata";
    private static final String NO_SIGNATURE = "missing signature";
    private static final String MISSING_KEY = "missing dnskey rrset";
    private static final String NSEC3_NO_DS = "nsec3s proved no ds";
    private static final String DNS_SD_DESC_EXT_PATTERN = ".(_[a-z-]+.){2}.+";
    private static final Map<String, String> decodingTable = new HashMap<String, String>();

    public static Resolver getResolver(boolean dnsSec, String trustAnchor, String server) throws ConfigurationException {
        Resolver resolver = DnsUtil.instantiateResolver(dnsSec, trustAnchor, server);
        if (resolver == null) {
            throw new ConfigurationException(String.format("Unable to retrieve a Resolver from [%s]", server));
        }
        return resolver;
    }

    public static Map<String, Resolver> getResolvers(boolean dnsSec, String trustAnchor) throws ConfigurationException {
        String[] servers = ResolverConfig.getCurrentConfig().servers();
        LinkedHashMap<String, Resolver> resolvers = new LinkedHashMap<String, Resolver>(servers.length);
        for (String server : servers) {
            Resolver resolver = DnsUtil.instantiateResolver(dnsSec, trustAnchor, server);
            if (resolver == null) continue;
            resolvers.put(server, resolver);
        }
        if (resolvers.isEmpty()) {
            throw new ConfigurationException("Unable to retrieve Default Resolvers");
        }
        return resolvers;
    }

    public static boolean checkDnsSec(Fqdn name, Resolver resolver, int rType) throws LookupException {
        try {
            ValidatingResolver validating = (ValidatingResolver)resolver;
            Record toValidate = Record.newRecord(Name.fromConstantString(name.fqdn()), rType, 1);
            Message dnsResponse = validating.send(Message.newQuery(toValidate));
            RRset[] rrSets = dnsResponse.getSectionRRsets(3);
            StringBuilder reason = new StringBuilder("");
            for (RRset rrset : rrSets) {
                if (!rrset.getName().equals(Name.root) || rrset.getType() != 16 || rrset.getDClass() != 65280) continue;
                reason.append(TextRecord.build((TXTRecord)rrset.first()).getRData());
            }
            StatusCode outcome = StatusCode.SUCCESSFUL_OPERATION;
            if (dnsResponse.getRcode() == 2) {
                if (reason.toString().toLowerCase().contains(CHAIN_OF_TRUST) || reason.toString().toLowerCase().contains(INSECURE)) {
                    outcome = StatusCode.RESOURCE_INSECURE_ERROR;
                } else if (reason.toString().toLowerCase().contains(NO_DATA)) {
                    outcome = StatusCode.NETWORK_ERROR;
                } else if (reason.toString().toLowerCase().contains(NO_SIGNATURE) || reason.toString().toLowerCase().contains(MISSING_KEY)) {
                    outcome = StatusCode.RESOLUTION_NAME_ERROR;
                }
            } else if (dnsResponse.getRcode() == 3) {
                outcome = reason.toString().toLowerCase().contains(NSEC3_NO_DS) ? StatusCode.RESOURCE_INSECURE_ERROR : StatusCode.RESOLUTION_NAME_ERROR;
            } else if (dnsResponse.getRcode() == 0 && !dnsResponse.getHeader().getFlag(10)) {
                outcome = StatusCode.RESOURCE_INSECURE_ERROR;
            }
            if (outcome != StatusCode.SUCCESSFUL_OPERATION) {
                throw ExceptionsUtil.build(outcome, "DNSSEC Validation Failed", new LinkedHashMap<String, StatusCode>());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static StatusCode checkLookupStatus(Lookup lookup2) throws LookupException {
        StatusCode outcome = null;
        outcome = lookup2.getResult() == 2 ? StatusCode.NETWORK_ERROR : (lookup2.getResult() == 1 ? StatusCode.SERVER_ERROR : (lookup2.getResult() == 3 ? StatusCode.RESOLUTION_NAME_ERROR : (lookup2.getResult() == 4 ? StatusCode.RESOLUTION_RR_TYPE_ERROR : StatusCode.SUCCESSFUL_OPERATION)));
        return outcome;
    }

    public static Lookup instantiateLookup(String domainName, Resolver resolver, int rrType, Cache cache) throws LookupException {
        Lookup lookup2 = null;
        try {
            lookup2 = new Lookup(domainName, rrType);
            lookup2.setResolver(resolver);
            lookup2.setCache(cache);
        }
        catch (TextParseException ex) {
            throw new LookupException(StatusCode.RESOURCE_LOOKUP_ERROR, String.format("Unable to crea a Lookup for [%s]", domainName));
        }
        return lookup2;
    }

    private static Resolver instantiateResolver(boolean dnsSec, String trustAnchor, String server) {
        try {
            SimpleResolver resolver = new SimpleResolver(server);
            if (!dnsSec) {
                return resolver;
            }
            ValidatingResolver validating = new ValidatingResolver(resolver);
            validating.loadTrustAnchors(new ByteArrayInputStream(trustAnchor.getBytes(StandardCharsets.UTF_8)));
            return validating;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Set<String> extractNamesFromRecords(Record[] records) {
        HashSet<String> serviceTypeNames = new HashSet<String>();
        for (Record record : records) {
            serviceTypeNames.add(RDataUtil.getServiceTypeRData(record.rdataToString()));
        }
        return serviceTypeNames;
    }

    public static Set<String> filterByType(String compType, Set<String> ptrs) {
        TreeSet<String> filtered = new TreeSet<String>();
        for (String ptr : ptrs) {
            if (!ptr.contains(compType)) continue;
            filtered.add(ptr);
        }
        return filtered;
    }

    public static LookupContext context(Fqdn name, String prefix, String label, String type, int rrType, boolean sec) {
        LookupContext ctx = new LookupContext();
        ctx.setDomainName(name);
        ctx.setPrefix(prefix);
        ctx.setLabel(label);
        ctx.setType(type);
        ctx.setRrType(rrType);
        ctx.setSecure(sec);
        return ctx;
    }

    public static String extractDnsSdDescription(String qname) {
        String escaped = qname.replaceAll(DNS_SD_DESC_EXT_PATTERN, "").replaceAll("\\\\", "").replaceAll("032", " ");
        for (String key : decodingTable.keySet()) {
            escaped = escaped.replaceAll(key, decodingTable.get(key));
        }
        return escaped;
    }

    private DnsUtil() {
        throw new AssertionError((Object)String.format("No instances of %s for you!", this.getClass().getName()));
    }

    static {
        decodingTable.put("195160", "\u00e0");
        decodingTable.put("195161", "\u00e1");
        decodingTable.put("195162", "\u00e2");
        decodingTable.put("195163", "\u00e3");
        decodingTable.put("195164", "\u00e4");
        decodingTable.put("195166", "\u00e6");
        decodingTable.put("195167", "\u00e7");
        decodingTable.put("195168", "\u00e8");
        decodingTable.put("195169", "\u00e9");
        decodingTable.put("195170", "\u00ea");
        decodingTable.put("195171", "\u00eb");
        decodingTable.put("195172", "\u00ec");
        decodingTable.put("195173", "\u00ed");
        decodingTable.put("195174", "\u00ee");
        decodingTable.put("195175", "\u00ef");
        decodingTable.put("195177", "\u00f1");
        decodingTable.put("195178", "\u00f2");
        decodingTable.put("195179", "\u00f3");
        decodingTable.put("195180", "\u00f4");
        decodingTable.put("195181", "\u00f5");
        decodingTable.put("195182", "\u00f6");
        decodingTable.put("195184", "\u00f8");
        decodingTable.put("195185", "\u0153");
        decodingTable.put("195186", "\u00f9");
        decodingTable.put("195187", "\u00fa");
        decodingTable.put("195188", "\u00fb");
        decodingTable.put("195188", "\u00fc");
        decodingTable.put("195132", "\u00c4");
        decodingTable.put("195150", "\u00d6");
        decodingTable.put("195156", "\u00dc");
        decodingTable.put("195159", "\u00df");
        decodingTable.put("226128153", "'");
        decodingTable.put("032", " ");
    }
}

