/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.utils;

import org.eclipse.iot.tiaki.domain.CompoundLabel;
import org.eclipse.iot.tiaki.domain.Fqdn;

public final class ValidatorUtil {
    public static final String FQDN_PATTERN = "^([(\\\\ )|(\\\\0-9)0-9a-zA-Z_-]+\\.){1,}$";
    public static final String DNS_SD_FQDN_PATTERN = "\\";
    public static final int FQDN_LENGTH = 255;

    public static void check(boolean what) throws IllegalArgumentException {
        if (!what) {
            throw new IllegalArgumentException("failed to assert");
        }
    }

    public static void isValidLabel(String label) throws IllegalArgumentException {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("null/blank label");
        }
    }

    public static void isValidLabel(CompoundLabel type) throws IllegalArgumentException {
        if (type == null || type.getType().isEmpty()) {
            throw new IllegalArgumentException("null or malformed label: type is mandatory");
        }
    }

    public static void isValidDomainName(Fqdn name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null/blank Fully Qualified Domain Name");
        }
        if (name.fqdn() == null || name.fqdn().isEmpty()) {
            throw new IllegalArgumentException("null/blank name");
        }
        if (!(ValidatorUtil.isDnsSdDomainName(name.fqdn()) || name.fqdn().matches(FQDN_PATTERN) && name.fqdn().length() <= 255)) {
            throw new IllegalArgumentException(String.format("invalid FQDN [%s]", name));
        }
    }

    public static void isValidDomainName(String name) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("null/blank name");
        }
        if (!(ValidatorUtil.isDnsSdDomainName(name) || name.matches(FQDN_PATTERN) && name.length() <= 255)) {
            throw new IllegalArgumentException(String.format("invalid FQDN [%s]", name));
        }
    }

    public static boolean isDnsSdDomainName(String name) {
        return name.contains(DNS_SD_FQDN_PATTERN);
    }

    public static boolean isValidPort(String portString) {
        try {
            int portInt = Integer.parseInt(portString);
            if (0 <= portInt && portInt <= 65535) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private ValidatorUtil() {
        throw new AssertionError((Object)String.format("No instances of %s for you!", this.getClass().getName()));
    }
}

