/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.ConnectionLifeCycleListener;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private final int maxSockets;
    private final boolean keepAlive;
    private final boolean pipelining;
    private final Map<TargetAddress, ConnQueue> connQueues = new ConcurrentHashMap<TargetAddress, ConnQueue>();

    ConnectionManager(int maxSockets, boolean keepAlive, boolean pipelining) {
        this.maxSockets = maxSockets;
        this.keepAlive = keepAlive;
        this.pipelining = pipelining;
    }

    public void getConnection(int port, String host, Handler<ClientConnection> handler, Handler<Throwable> connectionExceptionHandler, ContextImpl context) {
        if (!this.keepAlive && this.pipelining) {
            connectionExceptionHandler.handle(new IllegalStateException("Cannot have pipelining with no keep alive"));
        } else {
            ConnQueue prev;
            TargetAddress address = new TargetAddress(host, port);
            ConnQueue connQueue = this.connQueues.get(address);
            if (connQueue == null && (prev = this.connQueues.putIfAbsent(address, connQueue = new ConnQueue(address))) != null) {
                connQueue = prev;
            }
            connQueue.getConnection(handler, connectionExceptionHandler, context);
        }
    }

    protected abstract void connect(String var1, int var2, Handler<ClientConnection> var3, Handler<Throwable> var4, ContextImpl var5, ConnectionLifeCycleListener var6);

    public void close() {
        for (ConnQueue queue : this.connQueues.values()) {
            queue.closeAllConnections();
        }
        this.connQueues.clear();
    }

    private static class Waiter {
        final Handler<ClientConnection> handler;
        final Handler<Throwable> connectionExceptionHandler;
        final ContextImpl context;

        private Waiter(Handler<ClientConnection> handler, Handler<Throwable> connectionExceptionHandler, ContextImpl context) {
            this.handler = handler;
            this.connectionExceptionHandler = connectionExceptionHandler;
            this.context = context;
        }
    }

    private static class TargetAddress {
        final String host;
        final int port;

        private TargetAddress(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetAddress that = (TargetAddress)o;
            if (this.port != that.port) {
                return false;
            }
            return !(this.host != null ? !this.host.equals(that.host) : that.host != null);
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + this.port;
            return result;
        }
    }

    private class ConnQueue
    implements ConnectionLifeCycleListener {
        private final TargetAddress address;
        private final Queue<Waiter> waiters = new ArrayDeque<Waiter>();
        private final Set<ClientConnection> allConnections = new HashSet<ClientConnection>();
        private int connCount;

        ConnQueue(TargetAddress address) {
            this.address = address;
        }

        public synchronized void getConnection(Handler<ClientConnection> handler, Handler<Throwable> connectionExceptionHandler, ContextImpl context) {
            if (this.connCount == ConnectionManager.this.maxSockets) {
                this.waiters.add(new Waiter(handler, connectionExceptionHandler, context));
            } else {
                this.createNewConnection(handler, connectionExceptionHandler, context);
            }
        }

        @Override
        public synchronized void requestEnded(ClientConnection conn) {
            Waiter waiter;
            if (ConnectionManager.this.pipelining && (waiter = this.waiters.poll()) != null) {
                conn.getContext().executeFromIO(() -> waiter.handler.handle(conn));
            }
        }

        @Override
        public synchronized void responseEnded(ClientConnection conn) {
            if (ConnectionManager.this.pipelining) {
                if (conn.getOutstandingRequestCount() == 0 && this.waiters.isEmpty()) {
                    conn.close();
                }
            } else if (ConnectionManager.this.keepAlive) {
                this.checkReuseConnection(conn);
            } else {
                conn.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeAllConnections() {
            HashSet<ClientConnection> copy;
            ConnQueue connQueue = this;
            synchronized (connQueue) {
                copy = new HashSet<ClientConnection>(this.allConnections);
                this.allConnections.clear();
            }
            for (ClientConnection conn : copy) {
                try {
                    conn.close();
                }
                catch (Throwable t) {
                    log.error("Failed to close connection", t);
                }
            }
        }

        private void checkReuseConnection(ClientConnection conn) {
            Waiter waiter = this.waiters.poll();
            if (waiter != null) {
                conn.getContext().executeFromIO(() -> waiter.handler.handle(conn));
            } else {
                conn.close();
            }
        }

        private void createNewConnection(Handler<ClientConnection> handler, Handler<Throwable> connectionExceptionHandler, ContextImpl context) {
            ++this.connCount;
            ConnectionManager.this.connect(this.address.host, this.address.port, conn -> {
                this.allConnections.add((ClientConnection)conn);
                handler.handle((ClientConnection)conn);
            }, connectionExceptionHandler, context, this);
        }

        @Override
        public synchronized void connectionClosed(ClientConnection conn) {
            Waiter waiter;
            --this.connCount;
            if (conn != null) {
                this.allConnections.remove(conn);
            }
            if ((waiter = this.waiters.poll()) != null) {
                this.createNewConnection(waiter.handler, waiter.connectionExceptionHandler, waiter.context);
            } else if (this.connCount == 0) {
                ConnectionManager.this.connQueues.remove(this.address);
            }
        }
    }
}

