/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.IProvider;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;

public class BaseProvider<TYPE, ID>
implements IProvider<TYPE, ID> {
    private Map<ID, TYPE> m_instances = new LinkedHashMap<ID, TYPE>();

    @Override
    public TYPE get(ID id) {
        return this.m_instances.get(id);
    }

    @Override
    public Map<ID, TYPE> getAll() {
        return Collections.unmodifiableMap(this.m_instances);
    }

    @Override
    public boolean remove(ID id) {
        return this.m_instances.remove(id) != null;
    }

    @Override
    public void clear() {
        this.m_instances.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ids: ");
        for (ID id : this.m_instances.keySet()) {
            sb.append(id).append(", ");
        }
        return sb.toString();
    }

    protected BaseProvider<TYPE, ID> add(ID id, TYPE obj) {
        if (id == null) {
            DsfExceptionHelper.chuck((String)"id is null");
        }
        if (obj == null) {
            DsfExceptionHelper.chuck((String)"obj is null");
        }
        if (this.m_instances.containsKey(id)) {
            DsfExceptionHelper.chuck((String)("there is already an object registered with this id:" + id));
        }
        this.m_instances.put(id, obj);
        return this;
    }
}

