/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.trace.config.FilterKey;
import org.eclipse.vjet.dsf.common.trace.config.HandlerKey;
import org.eclipse.vjet.dsf.common.trace.config.ListenerConfig;
import org.eclipse.vjet.dsf.common.trace.config.ListenerKey;
import org.eclipse.vjet.dsf.common.trace.config.TraceConfigMgr;
import org.eclipse.vjet.dsf.common.trace.event.TraceEvent;
import org.eclipse.vjet.dsf.common.trace.filter.ITraceEventFilter;
import org.eclipse.vjet.dsf.common.trace.handler.ITraceEventHandler;
import org.eclipse.vjet.dsf.common.trace.listener.ITraceEventListener;
import org.eclipse.vjet.dsf.common.trace.listener.ListenerId;
import org.eclipse.vjet.dsf.common.tracer.Factory;

public class DefaultTraceEventListener
implements ITraceEventListener {
    private ListenerKey m_listenerKey;
    private final List<ITraceEventFilter> m_filters = new ArrayList<ITraceEventFilter>(1);
    private List<ITraceEventHandler> m_handlers = new ArrayList<ITraceEventHandler>(1);
    private static final TraceConfigMgr s_configBean = TraceConfigMgr.getInstance();

    public DefaultTraceEventListener(ListenerId id) {
        if (id == null) {
            DsfExceptionHelper.chuck((String)"id is null");
        }
        this.m_listenerKey = new ListenerKey(this.getClass(), id);
        ListenerConfig config = s_configBean.getListenerConfig(this.m_listenerKey);
        if (config != null) {
            this.addFilters(config);
            this.addHandlers(config);
        }
        if (this.m_handlers.isEmpty()) {
            this.m_handlers.add(TraceCtx.ctx().getTraceManager().getDefaultHandler());
        }
    }

    protected DefaultTraceEventListener() {
    }

    public ListenerId getId() {
        return this.m_listenerKey.getId();
    }

    public boolean isApplicable(TraceEvent event) {
        return true;
    }

    public void beforeTrace(TraceEvent event) {
    }

    public void trace(TraceEvent event) {
        for (ITraceEventFilter filter : this.m_filters) {
            if (filter.isInterested(event)) continue;
            return;
        }
        for (ITraceEventHandler handler : this.m_handlers) {
            handler.handle(event);
        }
    }

    public void afterTrace(TraceEvent event) {
    }

    public void close() {
        for (ITraceEventHandler handler : this.m_handlers) {
            handler.close();
        }
    }

    public ListenerKey getKey() {
        return this.m_listenerKey;
    }

    public boolean hasFilter(ITraceEventFilter filter) {
        if (filter == null) {
            return false;
        }
        for (ITraceEventFilter f : this.m_filters) {
            if (!f.getId().equals((Object)filter.getId()) || f.getClass() != filter.getClass()) continue;
            return true;
        }
        return false;
    }

    public void addFilter(ITraceEventFilter filter) {
        if (filter == null) {
            DsfExceptionHelper.chuck((String)"filter is null");
        }
        if (!this.hasFilter(filter)) {
            this.m_filters.add(filter);
        }
    }

    public List<ITraceEventFilter> getFilters() {
        if (this.m_filters.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_filters);
    }

    public void removeFilter(ITraceEventFilter filter) {
        this.m_filters.remove(filter);
    }

    public void removeAllFilters() {
        this.m_filters.clear();
    }

    public boolean hasHandler(ITraceEventHandler handler) {
        if (handler == null) {
            return false;
        }
        for (ITraceEventHandler h : this.m_handlers) {
            if (!h.getId().equals((Object)handler.getId()) || h.getClass() != handler.getClass()) continue;
            return true;
        }
        return false;
    }

    public void addHandler(ITraceEventHandler handler) {
        if (handler == null) {
            DsfExceptionHelper.chuck((String)"handler is null");
        }
        if (!this.hasHandler(handler)) {
            this.m_handlers.add(handler);
        }
    }

    public List<ITraceEventHandler> getHandlers() {
        if (this.m_handlers.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_handlers);
    }

    public void removeHandler(ITraceEventHandler handler) {
        this.m_handlers.remove(handler);
    }

    public void removeAllHandlers() {
        this.m_handlers.clear();
    }

    private void addFilters(ListenerConfig config) {
        if (config == null) {
            return;
        }
        List filterKeys = config.getFilters();
        if (!filterKeys.isEmpty()) {
            for (FilterKey key : filterKeys) {
                ITraceEventFilter filter = Factory.createFilter(key);
                this.m_filters.add(filter);
            }
        }
    }

    private void addHandlers(ListenerConfig config) {
        if (config == null) {
            return;
        }
        List handlerKeys = config.getHandlers();
        if (!handlerKeys.isEmpty()) {
            for (HandlerKey key : handlerKeys) {
                ITraceEventHandler handler = Factory.createHandler(key);
                this.m_handlers.add(handler);
            }
        }
    }
}

