/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.actions;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ITypeHierarchy;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.mod.debug.ui.actions.Messages;
import org.eclipse.dltk.mod.ui.dialogs.TypeSelectionExtension;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddExceptionTypeDialogExtension
extends TypeSelectionExtension {
    private Button fCaughtButton;
    private Button fUncaughtButton;
    private boolean fCaught = false;
    private boolean fUncaught = false;
    protected Object fExceptionBaseClassName;

    public AddExceptionTypeDialogExtension(String fExceptionBaseClassName, boolean caught, boolean uncaught) {
        this.fCaught = caught;
        this.fUncaught = uncaught;
    }

    public Control createContentArea(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)768);
        this.fCaughtButton = SWTFactory.createCheckButton((Composite)comp, (String)Messages.AddExceptionTypeDialogExtension_suspendOnCaught, null, (boolean)this.fCaught, (int)1);
        this.fCaughtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddExceptionTypeDialogExtension.this.fCaught = AddExceptionTypeDialogExtension.this.fCaughtButton.getSelection();
            }
        });
        this.fUncaughtButton = SWTFactory.createCheckButton((Composite)comp, (String)Messages.AddExceptionTypeDialogExtension_SuspendOnUncaught, null, (boolean)this.fUncaught, (int)1);
        this.fUncaughtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddExceptionTypeDialogExtension.this.fUncaught = AddExceptionTypeDialogExtension.this.fUncaughtButton.getSelection();
            }
        });
        return comp;
    }

    public ISelectionStatusValidator getSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    if (AddExceptionTypeDialogExtension.this.fExceptionBaseClassName == null) {
                        return Status.OK_STATUS;
                    }
                    try {
                        LinkedList<IType> queue = new LinkedList<IType>();
                        IType type = (IType)selection[0];
                        ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        Object curr = type;
                        while (curr != null) {
                            if (AddExceptionTypeDialogExtension.this.fExceptionBaseClassName.equals(curr.getFullyQualifiedName("."))) {
                                return Status.OK_STATUS;
                            }
                            IType[] superclasses = hierarchy.getSuperclass(curr);
                            if (superclasses != null) {
                                queue.addAll(Arrays.asList(superclasses));
                            }
                            curr = queue.size() > 0 ? (IType)queue.removeFirst() : null;
                        }
                    }
                    catch (ModelException e) {
                        DLTKDebugUIPlugin.log(e);
                        return Status.CANCEL_STATUS;
                    }
                }
                return new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), Messages.AddExceptionTypeDialogExtension_selectedItemIsNotAnException);
            }
        };
    }

    public boolean shouldHandleCaughtExceptions() {
        return this.fCaught;
    }

    public boolean shouldHandleUncaughtExceptions() {
        return this.fUncaught;
    }
}

