/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.commands;

import org.eclipse.dltk.mod.dbgp.IDbgpProperty;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpPropertyCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlEntityParser;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpPropertyCommands
extends DbgpBaseCommands
implements IDbgpPropertyCommands {
    private static final String PROPERTY_GET_COMMAND = "property_get";
    private static final String PROPERTY_SET_COMMAND = "property_set";

    protected IDbgpProperty parsePropertyResponse(Element response) throws DbgpException {
        NodeList properties = response.getElementsByTagName("property");
        return DbgpXmlEntityParser.parseProperty((Element)properties.item(0));
    }

    public DbgpPropertyCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    protected IDbgpProperty getProperty(String name, Integer stackDepth, Integer contextId) throws DbgpException {
        return this.getProperty(null, name, stackDepth, contextId);
    }

    protected IDbgpProperty getProperty(Integer page, String name, Integer stackDepth, Integer contextId) throws DbgpException {
        DbgpRequest request = this.createRequest(PROPERTY_GET_COMMAND);
        request.addOption("-n", name);
        if (stackDepth != null) {
            request.addOption("-d", stackDepth);
        }
        if (contextId != null) {
            request.addOption("-c", contextId);
        }
        if (page != null) {
            request.addOption("-p", page);
        }
        return this.parsePropertyResponse(this.communicate(request));
    }

    @Override
    public IDbgpProperty getPropertyByKey(String name, String key) throws DbgpException {
        DbgpRequest request = this.createRequest(PROPERTY_GET_COMMAND);
        request.addOption("-n", name);
        request.addOption("-k", key);
        return this.parsePropertyResponse(this.communicate(request));
    }

    @Override
    public IDbgpProperty getProperty(String name) throws DbgpException {
        return this.getProperty(name, null, null);
    }

    @Override
    public IDbgpProperty getProperty(String name, int stackDepth) throws DbgpException {
        return this.getProperty(name, new Integer(stackDepth), null);
    }

    @Override
    public IDbgpProperty getProperty(String name, int stackDepth, int contextId) throws DbgpException {
        return this.getProperty(name, new Integer(stackDepth), new Integer(contextId));
    }

    @Override
    public IDbgpProperty getProperty(int page, String name, int stackDepth) throws DbgpException {
        return this.getProperty(new Integer(page), name, new Integer(stackDepth), null);
    }

    @Override
    public boolean setProperty(IDbgpProperty property) throws DbgpException {
        DbgpRequest request = this.createRequest(PROPERTY_SET_COMMAND);
        request.addOption("-n", property.getName());
        request.setData(property.getValue());
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }

    @Override
    public boolean setProperty(String name, int stackDepth, String value) throws DbgpException {
        DbgpRequest request = this.createRequest(PROPERTY_SET_COMMAND);
        request.addOption("-n", name);
        request.addOption("-d", stackDepth);
        request.setData(value);
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }
}

