/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.Base64Helper;
import org.eclipse.vjet.dsf.js.dbgp.BreakPoint;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;

public class GetBreakPointCommand
extends DBGPDebugger.Command {
    private DBGPDebugger m_debugger;

    public GetBreakPointCommand(DBGPDebugger debugger) {
        this.m_debugger = debugger;
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        String id = options.get("-d");
        BreakPoint breakpoint = this.m_debugger.m_stackmanager.getBreakpoint(id);
        this.m_debugger.printResponse("<response command=\"breakpoint_get\"\r\n transaction_id=\"" + options.get("-i") + "\">\r\n" + "<breakpoint" + " id=\"" + id + "\"" + " type=\"" + breakpoint.getType() + "\"" + " state=\"" + breakpoint.getState() + "\"" + " filename=\"" + breakpoint.m_file + "\"" + " lineno=\"" + breakpoint.m_line + "\"" + " function=\"" + breakpoint.m_method + "\"" + " exception=\"" + "\"" + " hit_value=\"" + breakpoint.m_hitValue + "\"" + " hit_condition=\"" + breakpoint.getHitCondition() + "\"" + " hit_count=\"" + breakpoint.m_currentHitCount + "\"" + " >\r\n" + "<expression>" + Base64Helper.encodeString(breakpoint.m_expression) + "</expression>" + "</breakpoint>\r\n" + "</response>\r\n");
    }
}

