/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.dltk.mod.debug.core.DLTKDebugLaunchConstants;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.mod.debug.ui.Messages;
import org.eclipse.dltk.mod.debug.ui.ScriptDebugConsole;
import org.eclipse.dltk.mod.debug.ui.ScriptStreamProxy;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;

public class DebugConsoleManager
implements ILaunchListener {
    private static DebugConsoleManager instance;
    private Map launchToConsoleMap = new HashMap();

    public static DebugConsoleManager getInstance() {
        if (instance == null) {
            instance = new DebugConsoleManager();
        }
        return instance;
    }

    protected boolean acceptLaunch(ILaunch launch) {
        if (launch == null) {
            return false;
        }
        if (!"debug".equals(launch.getLaunchMode())) {
            return false;
        }
        return DLTKDebugLaunchConstants.isDebugConsole((ILaunch)launch);
    }

    protected ScriptDebugConsole createConsole(String name, ILaunch launch) {
        String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        if (encoding == null) {
            try {
                encoding = launch.getLaunchConfiguration().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", WorkbenchEncoding.getWorkbenchDefaultEncoding());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (encoding == null) {
                encoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            }
        }
        ScriptDebugConsole console = new ScriptDebugConsole(name, null, encoding);
        console.setLaunch(launch);
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{console});
        manager.showConsoleView((IConsole)console);
        return console;
    }

    protected void destroyConsole(IOConsole console) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.removeConsoles(new IConsole[]{console});
    }

    protected DebugConsoleManager() {
    }

    public void launchAdded(ILaunch launch) {
        if (!this.acceptLaunch(launch)) {
            return;
        }
        this.launchToConsoleMap.put(launch, this.createConsole(Messages.DebugConsoleManager_debugConsole, launch));
    }

    public void launchChanged(ILaunch launch) {
        ScriptDebugConsole console;
        IScriptDebugTarget target;
        if (!this.acceptLaunch(launch)) {
            return;
        }
        if (launch.getDebugTarget() instanceof IScriptDebugTarget && (target = (IScriptDebugTarget)launch.getDebugTarget()) != null && (console = (ScriptDebugConsole)((Object)this.launchToConsoleMap.get(launch))) != null && target.getStreamProxy() == null) {
            ScriptStreamProxy proxy = new ScriptStreamProxy(console);
            target.setStreamProxy((IScriptStreamProxy)proxy);
        }
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.acceptLaunch(launch)) {
            return;
        }
        ScriptDebugConsole console = (ScriptDebugConsole)((Object)this.launchToConsoleMap.get(launch));
        this.destroyConsole(console);
        this.launchToConsoleMap.remove(launch);
    }
}

