/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.launchConfigurations;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.mod.debug.ui.launchConfigurations.ScriptLaunchConfigurationTab;
import org.eclipse.dltk.mod.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.mod.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.mod.ui.preferences.FieldValidators;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public abstract class RemoteLaunchConfigurationTab
extends ScriptLaunchConfigurationTab {
    private static int DEFAULT_PORT = 10000;
    private static String DEFAULT_IDEKEY = "idekey";
    protected Text port;
    protected Text ideKey;
    protected Text remoteWorkingDir;
    protected Button stripSourceFolders;

    public RemoteLaunchConfigurationTab(String mode) {
        super(mode);
    }

    public String getName() {
        return DLTKLaunchConfigurationsMessages.remoteTab_title;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    @Override
    protected void doInitializeForm(ILaunchConfiguration config) {
        this.port.setText(LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"dbpg_port", (String)Integer.toString(this.getDefaultPort())));
        this.ideKey.setText(LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"dbgp_session_id", (String)this.getDefaultIDEKey()));
        this.remoteWorkingDir.setText(LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"remoteWorkingDir", (String)this.getDefaultRemoteWorkingDir()));
        this.stripSourceFolders.setSelection(LaunchConfigurationUtils.getBoolean((ILaunchConfiguration)config, (String)"stripSourceFolders", (boolean)this.getDefaultStripSourceFolders()));
    }

    protected int getDefaultPort() {
        return DEFAULT_PORT;
    }

    protected String getDefaultIDEKey() {
        return DEFAULT_IDEKEY;
    }

    protected String getDefaultRemoteWorkingDir() {
        return "";
    }

    protected boolean getDefaultStripSourceFolders() {
        return false;
    }

    @Override
    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("dbpg_port", this.port.getText().trim());
        config.setAttribute("dbgp_session_id", this.ideKey.getText().trim());
        config.setAttribute("remoteWorkingDir", this.remoteWorkingDir.getText().trim());
        config.setAttribute("stripSourceFolders", this.stripSourceFolders.getSelection());
    }

    @Override
    protected boolean validate() {
        return super.validate() && this.validatePort() && this.validateIdeKey() && this.validateRemoteWorkingDir();
    }

    protected boolean validatePort() {
        IStatus result = FieldValidators.PORT_VALIDATOR.validate(this.port.getText());
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        return true;
    }

    protected boolean validateIdeKey() {
        String key = this.ideKey.getText().trim();
        if (key.length() == 0) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.remoteError_ideKeyEmpty);
            return false;
        }
        return true;
    }

    protected boolean validateRemoteWorkingDir() {
        return true;
    }

    @Override
    protected void doCreateControl(Composite composite) {
        Group group = SWTFactory.createGroup((Composite)composite, (String)DLTKLaunchConfigurationsMessages.remoteTab_connectionProperties, (int)2, (int)1, (int)768);
        SWTFactory.createLabel((Composite)group, (String)DLTKLaunchConfigurationsMessages.remoteTab_connectionPort, (int)1);
        this.port = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.port.addModifyListener((ModifyListener)this.getWidgetListener());
        SWTFactory.createLabel((Composite)group, (String)DLTKLaunchConfigurationsMessages.remoteTab_connectionIdeKey, (int)1);
        this.ideKey = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.ideKey.addModifyListener((ModifyListener)this.getWidgetListener());
        SWTFactory.createHorizontalSpacer((Composite)composite, (int)1);
        group = SWTFactory.createGroup((Composite)composite, (String)DLTKLaunchConfigurationsMessages.remoteTab_remoteSourceMapping, (int)1, (int)1, (int)768);
        SWTFactory.createLabel((Composite)group, (String)DLTKLaunchConfigurationsMessages.remoteTab_remoteWorkingDir, (int)1);
        this.remoteWorkingDir = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.remoteWorkingDir.addModifyListener((ModifyListener)this.getWidgetListener());
        this.stripSourceFolders = this.createCheckButton((Composite)group, DLTKLaunchConfigurationsMessages.remoteTab_scriptSourceFolders);
        this.stripSourceFolders.addSelectionListener((SelectionListener)this.getWidgetListener());
    }
}

