/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ScriptModelUtil;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.mod.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

public class MonitoringNewNameQueries
implements INewNameQueries {
    private INewNameQueries fDelegate;
    private ReorgExecutionLog fExecutionLog;

    public MonitoringNewNameQueries(INewNameQueries delegate, ReorgExecutionLog log) {
        this.fDelegate = delegate;
        this.fExecutionLog = log;
    }

    @Override
    public INewNameQuery createNewSourceModuleNameQuery(final ISourceModule cu, final String initialSuggestedName) {
        return new INewNameQuery(){

            @Override
            public String getNewName() {
                String result = MonitoringNewNameQueries.this.fDelegate.createNewSourceModuleNameQuery(cu, initialSuggestedName).getNewName();
                String newName = ScriptModelUtil.getRenamedCUName((ISourceModule)cu, (String)result);
                MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)cu, newName);
                ResourceMapping mapping = DLTKElementResourceMapping.create(cu);
                if (mapping != null) {
                    MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)mapping, newName);
                }
                return result;
            }
        };
    }

    @Override
    public INewNameQuery createNewProjectFragmentNameQuery(final IProjectFragment root, final String initialSuggestedName) {
        return new INewNameQuery(){

            @Override
            public String getNewName() {
                String result = MonitoringNewNameQueries.this.fDelegate.createNewProjectFragmentNameQuery(root, initialSuggestedName).getNewName();
                MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)root, result);
                ResourceMapping mapping = DLTKElementResourceMapping.create(root);
                if (mapping != null) {
                    MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)mapping, result);
                }
                return result;
            }
        };
    }

    @Override
    public INewNameQuery createNewPackageNameQuery(final IScriptFolder pack, final String initialSuggestedName) {
        return new INewNameQuery(){

            @Override
            public String getNewName() {
                String result = MonitoringNewNameQueries.this.fDelegate.createNewPackageNameQuery(pack, initialSuggestedName).getNewName();
                MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)pack, result);
                ResourceMapping mapping = DLTKElementResourceMapping.create(pack);
                if (mapping != null) {
                    int index = result.lastIndexOf(46);
                    String newFolderName = index == -1 ? result : result.substring(index + 1);
                    MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)mapping, newFolderName);
                }
                return result;
            }
        };
    }

    @Override
    public INewNameQuery createNewResourceNameQuery(final IResource res, final String initialSuggestedName) {
        return new INewNameQuery(){

            @Override
            public String getNewName() {
                String result = MonitoringNewNameQueries.this.fDelegate.createNewResourceNameQuery(res, initialSuggestedName).getNewName();
                MonitoringNewNameQueries.this.fExecutionLog.setNewName((Object)res, result);
                return result;
            }
        };
    }

    @Override
    public INewNameQuery createNullQuery() {
        return this.fDelegate.createNullQuery();
    }

    @Override
    public INewNameQuery createStaticQuery(String newName) {
        return this.fDelegate.createStaticQuery(newName);
    }
}

