/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.internal.ui.dnd.DLTKViewerDragAdapter;
import org.eclipse.dltk.mod.internal.ui.dnd.EditorInputTransferDragAdapter;
import org.eclipse.dltk.mod.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.dltk.mod.internal.ui.scriptview.FileTransferDragAdapter;
import org.eclipse.dltk.mod.internal.ui.scriptview.SelectionTransferDragAdapter;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class DLTKViewerDragSupport {
    private final StructuredViewer fViewer;
    private final DLTKViewerDragAdapter fDragAdapter;
    private boolean fStarted;

    public DLTKViewerDragSupport(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.fDragAdapter = new DLTKViewerDragAdapter(this.fViewer);
        this.fDragAdapter.addDragSourceListener(new SelectionTransferDragAdapter((ISelectionProvider)this.fViewer));
        this.fDragAdapter.addDragSourceListener(new EditorInputTransferDragAdapter((ISelectionProvider)viewer));
        this.fDragAdapter.addDragSourceListener(new ResourceTransferDragAdapter((ISelectionProvider)this.fViewer));
        this.fDragAdapter.addDragSourceListener(new FileTransferDragAdapter((ISelectionProvider)this.fViewer));
        this.fStarted = false;
    }

    public void start() {
        Assert.isLegal((!this.fStarted ? 1 : 0) != 0);
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        this.fViewer.addDragSupport(ops, transfers, (DragSourceListener)this.fDragAdapter);
        this.fStarted = true;
    }
}

