/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.mod.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.mod.internal.core.ExternalSourceModule;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.ModelElementTransfer;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.mod.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;

    public PasteAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.setText(ReorgMessages.PasteAction_4);
        this.setDescription(ReorgMessages.PasteAction_5);
        ISharedImages workbenchImages = DLTKUIPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
    }

    private Paster[] createEnabledPasters(TransferData[] availableDataTypes) throws ModelException {
        Shell shell = this.getShell();
        ArrayList<Paster> result = new ArrayList<Paster>(2);
        Paster paster = new ProjectPaster(shell, this.fClipboard);
        if (paster.canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new ModelElementAndResourcePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new FilePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new WorkingSetPaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        return result.toArray(new Paster[result.size()]);
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] result = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = clipboard.getContents(transfer);
            }
        });
        return result[0];
    }

    private static boolean isAvailable(Transfer transfer, TransferData[] availableDataTypes) {
        int i = 0;
        while (i < availableDataTypes.length) {
            if (transfer.isSupportedType(availableDataTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            TransferData[] availableTypes = this.fClipboard.getAvailableTypes();
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IModelElement[] modelElements = ReorgUtils.getModelElements(elements);
            IWorkingSet[] workingSets = ReorgUtils.getWorkingSets(elements);
            Paster[] pasters = this.createEnabledPasters(availableTypes);
            int i = 0;
            while (i < pasters.length) {
                if (pasters[i].canPasteOn(modelElements, resources, workingSets)) {
                    pasters[i].paste(modelElements, resources, workingSets, availableTypes);
                    return;
                }
                ++i;
            }
            MessageDialog.openError((Shell)DLTKUIPlugin.getActiveWorkbenchShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_disabled);
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static class FilePaster
    extends Paster {
        protected FilePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public void paste(IModelElement[] modelElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws ModelException {
            String[] fileData = this.getClipboardFiles(availableTypes);
            if (fileData == null) {
                return;
            }
            IContainer container = this.getAsContainer(this.getTarget(modelElements, resources));
            if (container == null) {
                return;
            }
            new CopyFilesAndFoldersOperation(this.getShell()).copyFiles(fileData, container);
        }

        private Object getTarget(IModelElement[] modelElements, IResource[] resources) {
            if (modelElements.length + resources.length == 1) {
                if (modelElements.length == 1) {
                    return modelElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(modelElements, resources);
        }

        @Override
        public boolean canPasteOn(IModelElement[] modelElements, IResource[] resources, IWorkingSet[] selectedWorkingSets) throws ModelException {
            Object target = this.getTarget(modelElements, resources);
            return target != null && this.canPasteFilesOn(this.getAsContainer(target)) && selectedWorkingSets.length == 0;
        }

        @Override
        public boolean canEnable(TransferData[] availableDataTypes) throws ModelException {
            return PasteAction.isAvailable((Transfer)FileTransfer.getInstance(), availableDataTypes);
        }

        private boolean canPasteFilesOn(Object target) {
            boolean isScriptFolder = target instanceof IProjectFragment;
            boolean isScriptProject = target instanceof IScriptProject;
            boolean isProjectFragment = target instanceof IProjectFragment;
            boolean isContainer = target instanceof IContainer;
            if (target instanceof ExternalProjectFragment || target instanceof ExternalScriptFolder || target instanceof ExternalSourceModule) {
                return false;
            }
            if (!(isScriptFolder || isScriptProject || isProjectFragment || isContainer)) {
                return false;
            }
            if (isContainer) {
                return true;
            }
            IModelElement element = (IModelElement)target;
            return !element.isReadOnly();
        }

        private IContainer getAsContainer(Object target) throws ModelException {
            if (target == null) {
                return null;
            }
            if (target instanceof IContainer) {
                return (IContainer)target;
            }
            if (target instanceof IFile) {
                return ((IFile)target).getParent();
            }
            return this.getAsContainer(((IModelElement)target).getCorrespondingResource());
        }

        private String[] getClipboardFiles(TransferData[] availableDataTypes) {
            FileTransfer transfer = FileTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (String[])PasteAction.getContents(this.getClipboard(), (Transfer)transfer, this.getShell());
            }
            return null;
        }

        private Object getCommonParent(IModelElement[] modelElements, IResource[] resources) {
            return new ParentChecker(resources, modelElements).getCommonParent();
        }
    }

    private static class ModelElementAndResourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected ModelElementAndResourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public void paste(IModelElement[] modelElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws ModelException, InterruptedException, InvocationTargetException {
            Object destination;
            IModelElement[] clipboardScriptElements;
            IResource[] clipboardResources = this.getClipboardResources(availableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardScriptElements = this.getClipboardScriptElements(availableTypes)) == null) {
                clipboardScriptElements = new IModelElement[]{};
            }
            if ((destination = this.getTarget(modelElements, resources)) instanceof IModelElement) {
                ReorgCopyStarter.create(clipboardScriptElements, clipboardResources, (IModelElement)destination).run(this.getShell());
            } else if (destination instanceof IResource) {
                ReorgCopyStarter.create(clipboardScriptElements, clipboardResources, (IResource)destination).run(this.getShell());
            }
        }

        private Object getTarget(IModelElement[] modelElements, IResource[] resources) {
            if (modelElements.length + resources.length == 1) {
                if (modelElements.length == 1) {
                    return modelElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(modelElements, resources);
        }

        private Object getCommonParent(IModelElement[] modelElements, IResource[] resources) {
            return new ParentChecker(resources, modelElements).getCommonParent();
        }

        @Override
        public boolean canPasteOn(IModelElement[] modelElements, IResource[] resources, IWorkingSet[] selectedWorkingSets) throws ModelException {
            Object destination;
            IModelElement[] clipboardScriptElements;
            if (selectedWorkingSets.length != 0) {
                return false;
            }
            IResource[] clipboardResources = this.getClipboardResources(this.fAvailableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardScriptElements = this.getClipboardScriptElements(this.fAvailableTypes)) == null) {
                clipboardScriptElements = new IModelElement[]{};
            }
            if ((destination = this.getTarget(modelElements, resources)) instanceof IModelElement) {
                return ReorgCopyStarter.create(clipboardScriptElements, clipboardResources, (IModelElement)destination) != null;
            }
            if (destination instanceof IResource) {
                return ReorgCopyStarter.create(clipboardScriptElements, clipboardResources, (IResource)destination) != null;
            }
            return false;
        }

        @Override
        public boolean canEnable(TransferData[] availableTypes) {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)ModelElementTransfer.getInstance(), availableTypes) || PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableTypes);
        }
    }

    private static abstract class Paster {
        private final Shell fShell;
        private final Clipboard fClipboard2;

        protected Paster(Shell shell, Clipboard clipboard) {
            this.fShell = shell;
            this.fClipboard2 = clipboard;
        }

        protected final Shell getShell() {
            return this.fShell;
        }

        protected final Clipboard getClipboard() {
            return this.fClipboard2;
        }

        protected final IResource[] getClipboardResources(TransferData[] availableDataTypes) {
            ResourceTransfer transfer = ResourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IResource[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final IModelElement[] getClipboardScriptElements(TransferData[] availableDataTypes) {
            ModelElementTransfer transfer = ModelElementTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IModelElement[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final String getClipboardText(TransferData[] availableDataTypes) {
            TextTransfer transfer = TextTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (String)PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        public abstract void paste(IModelElement[] var1, IResource[] var2, IWorkingSet[] var3, TransferData[] var4) throws ModelException, InterruptedException, InvocationTargetException;

        public abstract boolean canEnable(TransferData[] var1) throws ModelException;

        public abstract boolean canPasteOn(IModelElement[] var1, IResource[] var2, IWorkingSet[] var3) throws ModelException;
    }

    private static class ProjectPaster
    extends Paster {
        protected ProjectPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public boolean canEnable(TransferData[] availableDataTypes) {
            boolean resourceTransfer = PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableDataTypes);
            boolean modelElementTransfer = PasteAction.isAvailable((Transfer)ModelElementTransfer.getInstance(), availableDataTypes);
            if (!modelElementTransfer) {
                return this.canPasteSimpleProjects(availableDataTypes);
            }
            if (!resourceTransfer) {
                return this.canPasteScriptProjects(availableDataTypes);
            }
            return this.canPasteScriptProjects(availableDataTypes) && this.canPasteSimpleProjects(availableDataTypes);
        }

        @Override
        public void paste(IModelElement[] modelElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) {
            this.pasteProjects(availableTypes);
        }

        private void pasteProjects(TransferData[] availableTypes) {
            this.pasteProjects(this.getProjectsToPaste(availableTypes));
        }

        private void pasteProjects(IProject[] projects) {
            Shell shell = this.getShell();
            int i = 0;
            while (i < projects.length) {
                new CopyProjectOperation(shell).copyProject(projects[i]);
                ++i;
            }
        }

        private IProject[] getProjectsToPaste(TransferData[] availableTypes) {
            IResource[] resources = this.getClipboardResources(availableTypes);
            IModelElement[] modelElements = this.getClipboardScriptElements(availableTypes);
            HashSet<IResource> result = new HashSet<IResource>();
            if (resources != null) {
                result.addAll(Arrays.asList(resources));
            }
            if (modelElements != null) {
                result.addAll(Arrays.asList(ReorgUtils.getNotNulls(ReorgUtils.getResources(modelElements))));
            }
            Assert.isTrue((result.size() > 0 ? 1 : 0) != 0);
            return result.toArray(new IProject[result.size()]);
        }

        @Override
        public boolean canPasteOn(IModelElement[] modelElements, IResource[] resources, IWorkingSet[] selectedWorkingSets) {
            return selectedWorkingSets.length == 0;
        }

        private boolean canPasteScriptProjects(TransferData[] availableDataTypes) {
            IModelElement[] modelElements = this.getClipboardScriptElements(availableDataTypes);
            return modelElements != null && modelElements.length != 0 && !ReorgUtils.hasElementsNotOfType(modelElements, 2);
        }

        private boolean canPasteSimpleProjects(TransferData[] availableDataTypes) {
            IResource[] resources = this.getClipboardResources(availableDataTypes);
            if (resources == null || resources.length == 0) {
                return false;
            }
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() != 4 || !((IProject)resources[i]).isOpen()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class WorkingSetPaster
    extends Paster {
        protected WorkingSetPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        @Override
        public void paste(IModelElement[] selectedScriptElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws ModelException, InterruptedException, InvocationTargetException {
            Object[] resources;
            IWorkingSet workingSet = selectedWorkingSets[0];
            HashSet<IAdaptable> elements = new HashSet<IAdaptable>(Arrays.asList(workingSet.getElements()));
            IModelElement[] modelElements = this.getClipboardScriptElements(availableTypes);
            if (modelElements != null) {
                int i = 0;
                while (i < modelElements.length) {
                    if (!ReorgUtils.containsElementOrParent(elements, modelElements[i])) {
                        elements.add((IAdaptable)modelElements[i]);
                    }
                    ++i;
                }
            }
            if ((resources = this.getClipboardResources(availableTypes)) != null) {
                ArrayList realScriptElements = new ArrayList();
                ArrayList realResource = new ArrayList();
                ReorgUtils.splitIntoModelElementsAndResources(resources, realScriptElements, realResource);
                for (IModelElement element : realScriptElements) {
                    if (ReorgUtils.containsElementOrParent(elements, element)) continue;
                    elements.add((IAdaptable)element);
                }
                for (IModelElement element : realResource) {
                    if (ReorgUtils.containsElementOrParent(elements, (IResource)element)) continue;
                    elements.add((IAdaptable)element);
                }
            }
            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }

        @Override
        public boolean canEnable(TransferData[] availableTypes) throws ModelException {
            return PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableTypes) || PasteAction.isAvailable((Transfer)ModelElementTransfer.getInstance(), availableTypes);
        }

        @Override
        public boolean canPasteOn(IModelElement[] selectedScriptElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets) throws ModelException {
            if (selectedResources.length != 0 || selectedScriptElements.length != 0 || selectedWorkingSets.length != 1) {
                return false;
            }
            IWorkingSet ws = selectedWorkingSets[0];
            return !"org.eclipse.dltk.mod.internal.ui.OthersWorkingSet".equals(ws.getId());
        }
    }
}

