/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.search.FieldReferenceMatch;
import org.eclipse.dltk.mod.core.search.SearchMatch;
import org.eclipse.dltk.mod.core.search.SearchParticipant;
import org.eclipse.dltk.mod.core.search.SearchRequestor;
import org.eclipse.dltk.mod.internal.ui.search.DLTKElementMatch;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchResult;

public class NewSearchResultCollector
extends SearchRequestor {
    private DLTKSearchResult fSearch;
    private boolean fIgnorePotentials;

    public NewSearchResultCollector(DLTKSearchResult search, boolean ignorePotentials) {
        this.fSearch = search;
        this.fIgnorePotentials = ignorePotentials;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IModelElement enclosingElement = (IModelElement)match.getElement();
        if (enclosingElement != null) {
            if (this.fIgnorePotentials && match.getAccuracy() == 1) {
                return;
            }
            boolean isWriteAccess = false;
            boolean isReadAccess = false;
            if (match instanceof FieldReferenceMatch) {
                FieldReferenceMatch fieldRef = (FieldReferenceMatch)match;
                isWriteAccess = fieldRef.isWriteAccess();
                isReadAccess = fieldRef.isReadAccess();
            }
            this.fSearch.addMatch(new DLTKElementMatch(enclosingElement, match.getRule(), match.getOffset(), match.getLength(), match.getAccuracy(), isReadAccess, isWriteAccess, match.isInsideDocComment()));
        }
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void enterParticipant(SearchParticipant participant) {
    }

    public void exitParticipant(SearchParticipant participant) {
    }
}

