/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.vjet.eclipse.internal.debug.ui.VjetDebugOptionsManager;
import org.osgi.framework.BundleContext;

public class VjetDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.vjet.eclipse.debug.ui";
    private static VjetDebugUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        VjetDebugUIPlugin.setPluginInstance(this);
        VjetDebugOptionsManager.getDefault().start();
    }

    public void stop(BundleContext context) throws Exception {
        VjetDebugOptionsManager.getDefault().stop();
        VjetDebugUIPlugin.setPluginInstance(null);
        super.stop(context);
    }

    private static void setPluginInstance(VjetDebugUIPlugin pluginPar) {
        plugin = pluginPar;
    }

    public static VjetDebugUIPlugin getDefault() {
        return plugin;
    }

    public static void error(String message) {
        VjetDebugUIPlugin.error(message, 4);
    }

    public static void error(String message, int status) {
        plugin.getLog().log((IStatus)new Status(status, PLUGIN_ID, 0, message, null));
    }

    public static void error(String message, Throwable t) {
        VjetDebugUIPlugin.error(message, t, 4);
    }

    public static void error(String message, Throwable t, int status) {
        VjetDebugUIPlugin.log((IStatus)new Status(status, PLUGIN_ID, 0, message, t));
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void errorDialog(Shell shell, String title, String msg, DebugException e) {
        IStatus status;
        String message = msg;
        if (e instanceof CoreException) {
            status = e.getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, PLUGIN_ID, 120, "Error within Debug UI: ", (Throwable)e);
            VjetDebugUIPlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }
}

