/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javalaunch.utils;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.vjet.eclipse.javalaunch.utils.EclipseResourceUtils;
import org.eclipse.vjet.eclipse.javalaunch.utils.LaunchUtilPlugin;

public class SourcePathUtil {
    public static String JAVA_SOURCE_PATH_PARAM = "java.source.path";

    public static String getSoucePathString(IProject launchProject) throws CoreException {
        return SourcePathUtil.getSourcePathString(launchProject);
    }

    public static String getSourcePathString(IProject launchProject) throws CoreException {
        IJavaProject javaProject = EclipseResourceUtils.getJavaProject(launchProject);
        ArrayList<File> sourcePaths = new ArrayList<File>(100);
        if (javaProject != null) {
            LinkedHashMap<String, IJavaProject> transitiveClosureProjectList = new LinkedHashMap<String, IJavaProject>();
            LinkedHashMap<String, IPath> transitiveLibrary = new LinkedHashMap<String, IPath>();
            transitiveClosureProjectList.put(javaProject.getElementName(), javaProject);
            EclipseResourceUtils.getTransitiveClosureDependencies(javaProject, transitiveClosureProjectList, transitiveLibrary);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            for (IJavaProject project : transitiveClosureProjectList.values()) {
                IClasspathEntry[] classPathEntries = project.getResolvedClasspath(true);
                EclipseResourceUtils.getProjectSourcePaths(sourcePaths, workspaceRoot, classPathEntries);
            }
            for (IPath path : transitiveLibrary.values()) {
                sourcePaths.add(path.toFile());
            }
        } else {
            return "";
        }
        StringBuilder sb = new StringBuilder(512);
        for (File sourcePath : sourcePaths) {
            sb.append(sourcePath.getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String configureVmArguments(String sourcePath, String vmArgs) {
        if (LaunchUtilPlugin.getConfigureSourcePathEnabled()) {
            vmArgs = SourcePathUtil.removeSourcePath(vmArgs);
            vmArgs = SourcePathUtil.addSourcePath(vmArgs, sourcePath);
        }
        return vmArgs.trim();
    }

    public static String getSourcePathParam() {
        return "-D" + JAVA_SOURCE_PATH_PARAM;
    }

    public static String addSourcePath(String vmArgs, String sourcePath) {
        String sourcePathParam = SourcePathUtil.getSourcePathParam();
        int javaSourcePathParamIndexStart = vmArgs.indexOf(sourcePathParam);
        if (javaSourcePathParamIndexStart < 0) {
            vmArgs = MessageFormat.format("{0} {1}={2}", vmArgs, sourcePathParam, sourcePath);
        }
        return vmArgs;
    }

    public static String removeSourcePath(String vmArgs) {
        if (vmArgs == null) {
            return "";
        }
        int javaSourcePathParamIndexStart = vmArgs.indexOf(SourcePathUtil.getSourcePathParam());
        if (javaSourcePathParamIndexStart >= 0) {
            int javaSourcePathParamIndexEnd = SourcePathUtil.getEndIndex(vmArgs, javaSourcePathParamIndexStart);
            vmArgs = MessageFormat.format("{0} {1}", vmArgs.substring(0, javaSourcePathParamIndexStart), vmArgs.substring(javaSourcePathParamIndexEnd, vmArgs.length()));
        }
        return vmArgs.trim();
    }

    private static int getEndIndex(String vmArgs, int pseudoTranslationArgIndexStart) {
        int endIdx = vmArgs.indexOf(" ", pseudoTranslationArgIndexStart);
        if (endIdx == -1) {
            endIdx = vmArgs.length();
        }
        return endIdx;
    }

    public static boolean getConfigureSourcePathEnabled() {
        return LaunchUtilPlugin.getDefault().getPreferenceStore().getBoolean("ConfigureSourcePath");
    }
}

